/*
YUI 3.14.0 (build a01e97d)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/dataschema-array/dataschema-array.js']) {
   __coverage__['build/dataschema-array/dataschema-array.js'] = {"path":"build/dataschema-array/dataschema-array.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0]},"f":{"1":0,"2":0,"3":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":28},"end":{"line":1,"column":47}}},"2":{"name":"(anonymous_2)","line":121,"loc":{"start":{"line":121,"column":15},"end":{"line":121,"column":38}}},"3":{"name":"(anonymous_3)","line":152,"loc":{"start":{"line":152,"column":23},"end":{"line":152,"column":60}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":186,"column":48}},"2":{"start":{"line":21,"column":0},"end":{"line":181,"column":6}},"3":{"start":{"line":122,"column":12},"end":{"line":123,"column":48}},"4":{"start":{"line":125,"column":12},"end":{"line":136,"column":13}},"5":{"start":{"line":126,"column":16},"end":{"line":132,"column":17}},"6":{"start":{"line":128,"column":20},"end":{"line":128,"column":108}},"7":{"start":{"line":131,"column":20},"end":{"line":131,"column":47}},"8":{"start":{"line":135,"column":16},"end":{"line":135,"column":73}},"9":{"start":{"line":138,"column":12},"end":{"line":138,"column":28}},"10":{"start":{"line":153,"column":12},"end":{"line":154,"column":60}},"11":{"start":{"line":156,"column":12},"end":{"line":176,"column":13}},"12":{"start":{"line":157,"column":16},"end":{"line":157,"column":28}},"13":{"start":{"line":158,"column":16},"end":{"line":158,"column":35}},"14":{"start":{"line":159,"column":16},"end":{"line":159,"column":135}},"15":{"start":{"line":160,"column":16},"end":{"line":174,"column":17}},"16":{"start":{"line":161,"column":20},"end":{"line":166,"column":21}},"17":{"start":{"line":162,"column":24},"end":{"line":162,"column":42}},"18":{"start":{"line":163,"column":24},"end":{"line":163,"column":81}},"19":{"start":{"line":164,"column":24},"end":{"line":164,"column":85}},"20":{"start":{"line":165,"column":24},"end":{"line":165,"column":87}},"21":{"start":{"line":168,"column":21},"end":{"line":174,"column":17}},"22":{"start":{"line":169,"column":20},"end":{"line":169,"column":34}},"23":{"start":{"line":173,"column":20},"end":{"line":173,"column":34}},"24":{"start":{"line":175,"column":16},"end":{"line":175,"column":36}},"25":{"start":{"line":177,"column":12},"end":{"line":177,"column":39}},"26":{"start":{"line":179,"column":12},"end":{"line":179,"column":28}},"27":{"start":{"line":183,"column":0},"end":{"line":183,"column":59}}},"branchMap":{"1":{"line":125,"type":"if","locations":[{"start":{"line":125,"column":12},"end":{"line":125,"column":12}},{"start":{"line":125,"column":12},"end":{"line":125,"column":12}}]},"2":{"line":126,"type":"if","locations":[{"start":{"line":126,"column":16},"end":{"line":126,"column":16}},{"start":{"line":126,"column":16},"end":{"line":126,"column":16}}]},"3":{"line":126,"type":"binary-expr","locations":[{"start":{"line":126,"column":19},"end":{"line":126,"column":25}},{"start":{"line":126,"column":29},"end":{"line":126,"column":62}}]},"4":{"line":159,"type":"cond-expr","locations":[{"start":{"line":159,"column":73},"end":{"line":159,"column":74}},{"start":{"line":159,"column":77},"end":{"line":159,"column":134}}]},"5":{"line":159,"type":"binary-expr","locations":[{"start":{"line":159,"column":24},"end":{"line":159,"column":43}},{"start":{"line":159,"column":47},"end":{"line":159,"column":69}}]},"6":{"line":159,"type":"cond-expr","locations":[{"start":{"line":159,"column":100},"end":{"line":159,"column":101}},{"start":{"line":159,"column":104},"end":{"line":159,"column":134}}]},"7":{"line":159,"type":"cond-expr","locations":[{"start":{"line":159,"column":128},"end":{"line":159,"column":129}},{"start":{"line":159,"column":132},"end":{"line":159,"column":134}}]},"8":{"line":160,"type":"if","locations":[{"start":{"line":160,"column":16},"end":{"line":160,"column":16}},{"start":{"line":160,"column":16},"end":{"line":160,"column":16}}]},"9":{"line":163,"type":"cond-expr","locations":[{"start":{"line":163,"column":63},"end":{"line":163,"column":72}},{"start":{"line":163,"column":75},"end":{"line":163,"column":80}}]},"10":{"line":164,"type":"cond-expr","locations":[{"start":{"line":164,"column":65},"end":{"line":164,"column":74}},{"start":{"line":164,"column":77},"end":{"line":164,"column":84}}]},"11":{"line":168,"type":"if","locations":[{"start":{"line":168,"column":21},"end":{"line":168,"column":21}},{"start":{"line":168,"column":21},"end":{"line":168,"column":21}}]}},"code":["(function () { YUI.add('dataschema-array', function (Y, NAME) {","","/**"," * Provides a DataSchema implementation which can be used to work with data"," * stored in arrays."," *"," * @module dataschema"," * @submodule dataschema-array"," */","","/**","Provides a DataSchema implementation which can be used to work with data","stored in arrays.","","See the `apply` method below for usage.","","@class DataSchema.Array","@extends DataSchema.Base","@static","**/","var LANG = Y.Lang,","","    SchemaArray = {","","        ////////////////////////////////////////////////////////////////////////","        //","        // DataSchema.Array static methods","        //","        ////////////////////////////////////////////////////////////////////////","","        /**","        Applies a schema to an array of data, returning a normalized object","        with results in the `results` property. The `meta` property of the","        response object is present for consistency, but is assigned an empty","        object.  If the input data is absent or not an array, an `error`","        property will be added.","","        The input array is expected to contain objects, arrays, or strings.","","        If _schema_ is not specified or _schema.resultFields_ is not an array,","        `response.results` will be assigned the input array unchanged.","","        When a _schema_ is specified, the following will occur:","","        If the input array contains strings, they will be copied as-is into the","        `response.results` array.","","        If the input array contains arrays, `response.results` will contain an","        array of objects with key:value pairs assuming the fields in","        _schema.resultFields_ are ordered in accordance with the data array","        values.","","        If the input array contains objects, the identified","        _schema.resultFields_ will be used to extract a value from those","        objects for the output result.","","        _schema.resultFields_ field identifiers are objects with the following properties:","","          * `key`   : <strong>(required)</strong> The locator name (String)","          * `parser`: A function or the name of a function on `Y.Parsers` used","                to convert the input value into a normalized type.  Parser","                functions are passed the value as input and are expected to","                return a value.","","        If no value parsing is needed, you can use strings as identifiers","        instead of objects (see example below).","","        @example","            // Process array of arrays","            var schema = { resultFields: [ 'fruit', 'color' ] },","                data = [","                    [ 'Banana', 'yellow' ],","                    [ 'Orange', 'orange' ],","                    [ 'Eggplant', 'purple' ]","                ];","","            var response = Y.DataSchema.Array.apply(schema, data);","","            // response.results[0] is { fruit: \"Banana\", color: \"yellow\" }","","","            // Process array of objects","            data = [","                { fruit: 'Banana', color: 'yellow', price: '1.96' },","                { fruit: 'Orange', color: 'orange', price: '2.04' },","                { fruit: 'Eggplant', color: 'purple', price: '4.31' }","            ];","","            response = Y.DataSchema.Array.apply(schema, data);","","            // response.results[0] is { fruit: \"Banana\", color: \"yellow\" }","","","            // Use parsers","            schema.resultFields = [","                {","                    key: 'fruit',","                    parser: function (val) { return val.toUpperCase(); }","                },","                {","                    key: 'price',","                    parser: 'number' // Uses Y.Parsers.number","                }","            ];","","            response = Y.DataSchema.Array.apply(schema, data);","","            // Note price was converted from a numeric string to a number","            // response.results[0] looks like { fruit: \"BANANA\", price: 1.96 }","","        @method apply","        @param {Object} [schema] Schema to apply.  Supported configuration","            properties are:","          @param {Array} [schema.resultFields] Field identifiers to","              locate/assign values in the response records. See above for","              details.","        @param {Array} data Array data.","        @return {Object} An Object with properties `results` and `meta`","        @static","        **/","        apply: function(schema, data) {","            var data_in = data,","                data_out = {results:[],meta:{}};","","            if(LANG.isArray(data_in)) {","                if(schema && LANG.isArray(schema.resultFields)) {","                    // Parse results data","                    data_out = SchemaArray._parseResults.call(this, schema.resultFields, data_in, data_out);","                }","                else {","                    data_out.results = data_in;","                }","            }","            else {","                data_out.error = new Error(\"Array schema parse failure\");","            }","","            return data_out;","        },","","        /**","         * Schema-parsed list of results from full data","         *","         * @method _parseResults","         * @param fields {Array} Schema to parse against.","         * @param array_in {Array} Array to parse.","         * @param data_out {Object} In-progress parsed data to update.","         * @return {Object} Parsed data object.","         * @static","         * @protected","         */","        _parseResults: function(fields, array_in, data_out) {","            var results = [],","                result, item, type, field, key, value, i, j;","","            for(i=array_in.length-1; i>-1; i--) {","                result = {};","                item = array_in[i];","                type = (LANG.isObject(item) && !LANG.isFunction(item)) ? 2 : (LANG.isArray(item)) ? 1 : (LANG.isString(item)) ? 0 : -1;","                if(type > 0) {","                    for(j=fields.length-1; j>-1; j--) {","                        field = fields[j];","                        key = (!LANG.isUndefined(field.key)) ? field.key : field;","                        value = (!LANG.isUndefined(item[key])) ? item[key] : item[j];","                        result[key] = Y.DataSchema.Base.parse.call(this, value, field);","                    }","                }","                else if(type === 0) {","                    result = item;","                }","                else {","                    //TODO: null or {}?","                    result = null;","                }","                results[i] = result;","            }","            data_out.results = results;","","            return data_out;","        }","    };","","Y.DataSchema.Array = Y.mix(SchemaArray, Y.DataSchema.Base);","","","}, '3.14.0', {\"requires\": [\"dataschema-base\"]});","","}());"]};
}
var __cov_vYlnaMgz3BdRYKf0PsHDOg = __coverage__['build/dataschema-array/dataschema-array.js'];
__cov_vYlnaMgz3BdRYKf0PsHDOg.s['1']++;YUI.add('dataschema-array',function(Y,NAME){__cov_vYlnaMgz3BdRYKf0PsHDOg.f['1']++;__cov_vYlnaMgz3BdRYKf0PsHDOg.s['2']++;var LANG=Y.Lang,SchemaArray={apply:function(schema,data){__cov_vYlnaMgz3BdRYKf0PsHDOg.f['2']++;__cov_vYlnaMgz3BdRYKf0PsHDOg.s['3']++;var data_in=data,data_out={results:[],meta:{}};__cov_vYlnaMgz3BdRYKf0PsHDOg.s['4']++;if(LANG.isArray(data_in)){__cov_vYlnaMgz3BdRYKf0PsHDOg.b['1'][0]++;__cov_vYlnaMgz3BdRYKf0PsHDOg.s['5']++;if((__cov_vYlnaMgz3BdRYKf0PsHDOg.b['3'][0]++,schema)&&(__cov_vYlnaMgz3BdRYKf0PsHDOg.b['3'][1]++,LANG.isArray(schema.resultFields))){__cov_vYlnaMgz3BdRYKf0PsHDOg.b['2'][0]++;__cov_vYlnaMgz3BdRYKf0PsHDOg.s['6']++;data_out=SchemaArray._parseResults.call(this,schema.resultFields,data_in,data_out);}else{__cov_vYlnaMgz3BdRYKf0PsHDOg.b['2'][1]++;__cov_vYlnaMgz3BdRYKf0PsHDOg.s['7']++;data_out.results=data_in;}}else{__cov_vYlnaMgz3BdRYKf0PsHDOg.b['1'][1]++;__cov_vYlnaMgz3BdRYKf0PsHDOg.s['8']++;data_out.error=new Error('Array schema parse failure');}__cov_vYlnaMgz3BdRYKf0PsHDOg.s['9']++;return data_out;},_parseResults:function(fields,array_in,data_out){__cov_vYlnaMgz3BdRYKf0PsHDOg.f['3']++;__cov_vYlnaMgz3BdRYKf0PsHDOg.s['10']++;var results=[],result,item,type,field,key,value,i,j;__cov_vYlnaMgz3BdRYKf0PsHDOg.s['11']++;for(i=array_in.length-1;i>-1;i--){__cov_vYlnaMgz3BdRYKf0PsHDOg.s['12']++;result={};__cov_vYlnaMgz3BdRYKf0PsHDOg.s['13']++;item=array_in[i];__cov_vYlnaMgz3BdRYKf0PsHDOg.s['14']++;type=(__cov_vYlnaMgz3BdRYKf0PsHDOg.b['5'][0]++,LANG.isObject(item))&&(__cov_vYlnaMgz3BdRYKf0PsHDOg.b['5'][1]++,!LANG.isFunction(item))?(__cov_vYlnaMgz3BdRYKf0PsHDOg.b['4'][0]++,2):(__cov_vYlnaMgz3BdRYKf0PsHDOg.b['4'][1]++,LANG.isArray(item)?(__cov_vYlnaMgz3BdRYKf0PsHDOg.b['6'][0]++,1):(__cov_vYlnaMgz3BdRYKf0PsHDOg.b['6'][1]++,LANG.isString(item)?(__cov_vYlnaMgz3BdRYKf0PsHDOg.b['7'][0]++,0):(__cov_vYlnaMgz3BdRYKf0PsHDOg.b['7'][1]++,-1)));__cov_vYlnaMgz3BdRYKf0PsHDOg.s['15']++;if(type>0){__cov_vYlnaMgz3BdRYKf0PsHDOg.b['8'][0]++;__cov_vYlnaMgz3BdRYKf0PsHDOg.s['16']++;for(j=fields.length-1;j>-1;j--){__cov_vYlnaMgz3BdRYKf0PsHDOg.s['17']++;field=fields[j];__cov_vYlnaMgz3BdRYKf0PsHDOg.s['18']++;key=!LANG.isUndefined(field.key)?(__cov_vYlnaMgz3BdRYKf0PsHDOg.b['9'][0]++,field.key):(__cov_vYlnaMgz3BdRYKf0PsHDOg.b['9'][1]++,field);__cov_vYlnaMgz3BdRYKf0PsHDOg.s['19']++;value=!LANG.isUndefined(item[key])?(__cov_vYlnaMgz3BdRYKf0PsHDOg.b['10'][0]++,item[key]):(__cov_vYlnaMgz3BdRYKf0PsHDOg.b['10'][1]++,item[j]);__cov_vYlnaMgz3BdRYKf0PsHDOg.s['20']++;result[key]=Y.DataSchema.Base.parse.call(this,value,field);}}else{__cov_vYlnaMgz3BdRYKf0PsHDOg.b['8'][1]++;__cov_vYlnaMgz3BdRYKf0PsHDOg.s['21']++;if(type===0){__cov_vYlnaMgz3BdRYKf0PsHDOg.b['11'][0]++;__cov_vYlnaMgz3BdRYKf0PsHDOg.s['22']++;result=item;}else{__cov_vYlnaMgz3BdRYKf0PsHDOg.b['11'][1]++;__cov_vYlnaMgz3BdRYKf0PsHDOg.s['23']++;result=null;}}__cov_vYlnaMgz3BdRYKf0PsHDOg.s['24']++;results[i]=result;}__cov_vYlnaMgz3BdRYKf0PsHDOg.s['25']++;data_out.results=results;__cov_vYlnaMgz3BdRYKf0PsHDOg.s['26']++;return data_out;}};__cov_vYlnaMgz3BdRYKf0PsHDOg.s['27']++;Y.DataSchema.Array=Y.mix(SchemaArray,Y.DataSchema.Base);},'3.14.0',{'requires':['dataschema-base']});
