/*
YUI 3.14.0 (build a01e97d)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/datatable-column-widths/datatable-column-widths.js']) {
   __coverage__['build/datatable-column-widths/datatable-column-widths.js'] = {"path":"build/datatable-column-widths/datatable-column-widths.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0],"13":[0,0],"14":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":35},"end":{"line":1,"column":54}}},"2":{"name":"(anonymous_2)","line":15,"loc":{"start":{"line":15,"column":10},"end":{"line":15,"column":22}}},"3":{"name":"ColumnWidths","line":117,"loc":{"start":{"line":117,"column":0},"end":{"line":117,"column":24}}},"4":{"name":"(anonymous_4)","line":157,"loc":{"start":{"line":157,"column":20},"end":{"line":157,"column":41}}},"5":{"name":"(anonymous_5)","line":184,"loc":{"start":{"line":184,"column":24},"end":{"line":184,"column":36}}},"6":{"name":"(anonymous_6)","line":196,"loc":{"start":{"line":196,"column":17},"end":{"line":196,"column":29}}},"7":{"name":"(anonymous_7)","line":216,"loc":{"start":{"line":216,"column":21},"end":{"line":216,"column":48}}},"8":{"name":"(anonymous_8)","line":239,"loc":{"start":{"line":239,"column":32},"end":{"line":239,"column":48}}},"9":{"name":"(anonymous_9)","line":265,"loc":{"start":{"line":265,"column":24},"end":{"line":265,"column":36}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":323,"column":47}},"2":{"start":{"line":11,"column":0},"end":{"line":12,"column":33}},"3":{"start":{"line":14,"column":0},"end":{"line":45,"column":3}},"4":{"start":{"line":16,"column":8},"end":{"line":17,"column":25}},"5":{"start":{"line":19,"column":8},"end":{"line":41,"column":9}},"6":{"start":{"line":25,"column":12},"end":{"line":36,"column":40}},"7":{"start":{"line":38,"column":12},"end":{"line":38,"column":72}},"8":{"start":{"line":40,"column":12},"end":{"line":40,"column":30}},"9":{"start":{"line":43,"column":8},"end":{"line":43,"column":22}},"10":{"start":{"line":117,"column":0},"end":{"line":117,"column":26}},"11":{"start":{"line":119,"column":0},"end":{"line":292,"column":9}},"12":{"start":{"line":158,"column":8},"end":{"line":159,"column":65}},"13":{"start":{"line":161,"column":8},"end":{"line":169,"column":9}},"14":{"start":{"line":162,"column":12},"end":{"line":164,"column":13}},"15":{"start":{"line":163,"column":16},"end":{"line":163,"column":30}},"16":{"start":{"line":166,"column":12},"end":{"line":166,"column":30}},"17":{"start":{"line":168,"column":12},"end":{"line":168,"column":47}},"18":{"start":{"line":171,"column":8},"end":{"line":171,"column":20}},"19":{"start":{"line":185,"column":8},"end":{"line":185,"column":53}},"20":{"start":{"line":197,"column":8},"end":{"line":197,"column":77}},"21":{"start":{"line":222,"column":8},"end":{"line":224,"column":28}},"22":{"start":{"line":226,"column":8},"end":{"line":253,"column":9}},"23":{"start":{"line":227,"column":12},"end":{"line":229,"column":13}},"24":{"start":{"line":228,"column":16},"end":{"line":228,"column":30}},"25":{"start":{"line":231,"column":12},"end":{"line":231,"column":41}},"26":{"start":{"line":235,"column":12},"end":{"line":252,"column":13}},"27":{"start":{"line":236,"column":16},"end":{"line":236,"column":51}},"28":{"start":{"line":238,"column":16},"end":{"line":251,"column":17}},"29":{"start":{"line":239,"column":20},"end":{"line":241,"column":22}},"30":{"start":{"line":240,"column":24},"end":{"line":240,"column":76}},"31":{"start":{"line":243,"column":20},"end":{"line":249,"column":62}},"32":{"start":{"line":266,"column":8},"end":{"line":268,"column":9}},"33":{"start":{"line":267,"column":12},"end":{"line":267,"column":19}},"34":{"start":{"line":270,"column":8},"end":{"line":273,"column":19}},"35":{"start":{"line":275,"column":8},"end":{"line":283,"column":9}},"36":{"start":{"line":276,"column":12},"end":{"line":276,"column":70}},"37":{"start":{"line":278,"column":12},"end":{"line":280,"column":66}},"38":{"start":{"line":282,"column":12},"end":{"line":282,"column":29}},"39":{"start":{"line":285,"column":8},"end":{"line":290,"column":9}},"40":{"start":{"line":287,"column":12},"end":{"line":287,"column":38}},"41":{"start":{"line":289,"column":12},"end":{"line":289,"column":54}},"42":{"start":{"line":294,"column":0},"end":{"line":294,"column":40}},"43":{"start":{"line":296,"column":0},"end":{"line":296,"column":40}}},"branchMap":{"1":{"line":19,"type":"if","locations":[{"start":{"line":19,"column":8},"end":{"line":19,"column":8}},{"start":{"line":19,"column":8},"end":{"line":19,"column":8}}]},"2":{"line":159,"type":"binary-expr","locations":[{"start":{"line":159,"column":20},"end":{"line":159,"column":23}},{"start":{"line":159,"column":27},"end":{"line":159,"column":64}}]},"3":{"line":161,"type":"if","locations":[{"start":{"line":161,"column":8},"end":{"line":161,"column":8}},{"start":{"line":161,"column":8},"end":{"line":161,"column":8}}]},"4":{"line":162,"type":"if","locations":[{"start":{"line":162,"column":12},"end":{"line":162,"column":12}},{"start":{"line":162,"column":12},"end":{"line":162,"column":12}}]},"5":{"line":223,"type":"binary-expr","locations":[{"start":{"line":223,"column":24},"end":{"line":223,"column":32}},{"start":{"line":223,"column":36},"end":{"line":223,"column":70}}]},"6":{"line":226,"type":"if","locations":[{"start":{"line":226,"column":8},"end":{"line":226,"column":8}},{"start":{"line":226,"column":8},"end":{"line":226,"column":8}}]},"7":{"line":227,"type":"if","locations":[{"start":{"line":227,"column":12},"end":{"line":227,"column":12}},{"start":{"line":227,"column":12},"end":{"line":227,"column":12}}]},"8":{"line":227,"type":"binary-expr","locations":[{"start":{"line":227,"column":16},"end":{"line":227,"column":21}},{"start":{"line":227,"column":25},"end":{"line":227,"column":40}}]},"9":{"line":235,"type":"if","locations":[{"start":{"line":235,"column":12},"end":{"line":235,"column":12}},{"start":{"line":235,"column":12},"end":{"line":235,"column":12}}]},"10":{"line":235,"type":"binary-expr","locations":[{"start":{"line":235,"column":17},"end":{"line":235,"column":22}},{"start":{"line":235,"column":26},"end":{"line":235,"column":65}}]},"11":{"line":238,"type":"if","locations":[{"start":{"line":238,"column":16},"end":{"line":238,"column":16}},{"start":{"line":238,"column":16},"end":{"line":238,"column":16}}]},"12":{"line":240,"type":"binary-expr","locations":[{"start":{"line":240,"column":31},"end":{"line":240,"column":72}},{"start":{"line":240,"column":74},"end":{"line":240,"column":75}}]},"13":{"line":266,"type":"if","locations":[{"start":{"line":266,"column":8},"end":{"line":266,"column":8}},{"start":{"line":266,"column":8},"end":{"line":266,"column":8}}]},"14":{"line":275,"type":"if","locations":[{"start":{"line":275,"column":8},"end":{"line":275,"column":8}},{"start":{"line":275,"column":8},"end":{"line":275,"column":8}}]}},"code":["(function () { YUI.add('datatable-column-widths', function (Y, NAME) {","","/**","Adds basic, programmatic column width support to DataTable via column","configuration property `width` and method `table.setColumnWidth(id, width);`.","","@module datatable","@submodule datatable-column-widths","@since 3.5.0","**/","var isNumber = Y.Lang.isNumber,","    arrayIndex = Y.Array.indexOf;","","Y.Features.add('table', 'badColWidth', {","    test: function () {","        var body = Y.one('body'),","            node, broken;","","        if (body) {","            // In modern browsers, <col style=\"width:X\"> will make columns,","            // *including padding and borders* X wide. The cell content width","            // is reduced.  In old browsers and all Opera versions to date, the","            // col's width style is passed to the cells, which causes cell","            // padding/border to bloat the rendered width.","            node = body.insertBefore(","                '<table style=\"position:absolute;visibility:hidden;border:0 none\">' +","                    '<colgroup><col style=\"width:9px\"></colgroup>' +","                    '<tbody><tr>' +","                        '<td style=\"' +","                            'padding:0 4px;' +","                            'font:normal 2px/2px arial;' +","                            'border:0 none\">' +","                        '.' + // Just something to give the cell dimension","                    '</td></tr></tbody>' +","                '</table>',","                body.get('firstChild'));","","            broken = node.one('td').getComputedStyle('width') !== '1px';","","            node.remove(true);","        }","","        return broken;","    }","});","","/**","_API docs for this extension are included in the DataTable class._","","Adds basic, programmatic column width support to DataTable. Note, this does not","add support for truncated columns.  Due to the way HTML tables render, column","width is more like a \"recommended width\".  Column content wider than the","assigned width will cause the column to expand, despite the configured width.","Similarly if the table is too narrow to fit the column with the configured","column width, the column width will be reduced.","","To set a column width, either add a `width` value to the column configuration","or call the `setColumnWidth(id, width)` method.","","Note, assigning column widths is possible without this module, as each cell is","decorated with a class appropriate for that column which you can statically","target in your site's CSS.","","To achieve absolute column widths, with content truncation, you can either:","","1. Use this module, configure *all* columns to have `width`s, then add","   `table-layout: fixed;` to your CSS for the appropriate `<table>`, or","2. Wrap the contents of all cells in the column with a `<div>` (using a","   `cellTemplate` or `formatter`), assign the div's style `width`, then assign","   the column `width` or add a CSS `width` to the column class created by","   DataTable.","","<pre><code>.yui3-datatable .yui3-datatable-col-foo {","    padding: 0;","    width: 125px;","}",".yui3-datatable .yui3-datatable-col-foo .yui3-datatable-liner {","    overflow: hidden;","    padding: 4px 10px;","    width: 125px;","}","</pre></code>","","<pre><code>var table = new Y.DataTable({","    columns: [","        {","            key: 'foo',","            cellTemplate:","                '&lt;td class=\"{className}\">' +","                    '&lt;div class=\"yui3-datatable-liner\">{content}&lt;/div>' +","                '&lt;/td>'","        },","        ...","    ],","    ...","});","</code></pre>","","To add a liner to all columns, either provide a custom `bodyView` to the","DataTable constructor or update the default `bodyView`'s `CELL_TEMPLATE` like","so:","","<pre><code>table.on('table:renderBody', function (e) {","    e.view.CELL_TEMPLATE = e.view.CELL_TEMPLATE.replace(/\\{content\\}/,","            '&lt;div class=\"yui3-datatable-liner\">{content}&lt;/div>');","});","</code></pre>","","Keep in mind that DataTable skins apply cell `padding`, so assign your CSS","`width`s accordingly or override the `padding` style for that column's `<td>`s","to 0, and add `padding` to the liner `<div>`'s styles as shown above.","","@class DataTable.ColumnWidths","@for DataTable","@since 3.5.0","**/","function ColumnWidths() {}","","Y.mix(ColumnWidths.prototype, {","    /**","    The HTML template used to create the table's `<col>`s.","","    @property COL_TEMPLATE","    @type {HTML}","    @default '<col/>'","    @since 3.5.0","    **/","    COL_TEMPLATE: '<col/>',","","    /**","    The HTML template used to create the table's `<colgroup>`.","","    @property COLGROUP_TEMPLATE","    @type {HTML}","    @default '<colgroup/>'","    @since 3.5.0","    **/","    COLGROUP_TEMPLATE: '<colgroup/>',","","    /**","    Assigns the style width of the `<col>` representing the column identifed by","    `id` and updates the column configuration.","","    Pass the empty string for `width` to return a column to auto sizing.","","    This does not trigger a `columnsChange` event today, but I can be convinced","    that it should.","","    @method setColumnWidth","    @param {Number|String|Object} id The column config object or key, name, or","            index of a column in the host's `_displayColumns` array.","    @param {Number|String} width CSS width value. Numbers are treated as pixels","    @return {DataTable}","    @chainable","    @since 3.5.0","    **/","    setColumnWidth: function (id, width) {","        var col = this.getColumn(id),","            index = col && arrayIndex(this._displayColumns, col);","","        if (index > -1) {","            if (isNumber(width)) {","                width += 'px';","            }","","            col.width = width;","","            this._setColumnWidth(index, width);","        }","","        return this;","    },","","    //--------------------------------------------------------------------------","    // Protected properties and methods","    //--------------------------------------------------------------------------","    /**","    Renders the table's `<colgroup>` and populates the `_colgroupNode` property.","","    @method _createColumnGroup","    @protected","    @since 3.5.0","    **/","    _createColumnGroup: function () {","        return Y.Node.create(this.COLGROUP_TEMPLATE);","    },","","    /**","    Hooks up to the rendering lifecycle to also render the `<colgroup>` and","    subscribe to `columnChange` events.","","    @method initializer","    @protected","    @since 3.5.0","    **/","    initializer: function () {","        this.after(['renderView', 'columnsChange'], this._uiSetColumnWidths);","    },","","    /**","    Sets a columns's `<col>` element width style. This is needed to get around","    browser rendering differences.","","    The colIndex corresponds to the item index of the `<col>` in the table's","    `<colgroup>`.","","    To unset the width, pass a falsy value for the `width`.","","    @method _setColumnWidth","    @param {Number} colIndex The display column index","    @param {Number|String} width The desired width","    @protected","    @since 3.5.0","    **/","    // TODO: move this to a conditional module","    _setColumnWidth: function (colIndex, width) {","        // Opera (including Opera Next circa 1/13/2012) and IE7- pass on the","        // width style to the cells directly, allowing padding and borders to","        // expand the rendered width.  Chrome 16, Safari 5.1.1, and FF 3.6+ all","        // make the rendered width equal the col's style width, reducing the","        // cells' calculated width.","        var colgroup  = this._colgroupNode,","            col       = colgroup && colgroup.all('col').item(colIndex),","            cell, getCStyle;","","        if (col) {","            if (width && isNumber(width)) {","                width += 'px';","            }","","            col.setStyle('width', width);","","            // Adjust the width for browsers that make","            // td.style.width === col.style.width","            if  (width && Y.Features.test('table', 'badColWidth')) {","                cell = this.getCell([0, colIndex]);","","                if (cell) {","                    getCStyle = function (prop) {","                        return parseInt(cell.getComputedStyle(prop), 10)||0;","                    };","","                    col.setStyle('width',","                        // I hate this","                        parseInt(width, 10) -","                        getCStyle('paddingLeft') -","                        getCStyle('paddingRight') -","                        getCStyle('borderLeftWidth') -","                        getCStyle('borderRightWidth') + 'px');","","                }","            }","        }","    },","","    /**","    Populates the table's `<colgroup>` with a `<col>` per item in the `columns`","    attribute without children.  It is assumed that these are the columns that","    have data cells renderered for them.","","    @method _uiSetColumnWidths","    @protected","    @since 3.5.0","    **/","    _uiSetColumnWidths: function () {","        if (!this.view) {","            return;","        }","","        var template = this.COL_TEMPLATE,","            colgroup = this._colgroupNode,","            columns  = this._displayColumns,","            i, len;","","        if (!colgroup) {","            colgroup = this._colgroupNode = this._createColumnGroup();","","            this._tableNode.insertBefore(","                colgroup,","                this._tableNode.one('> thead, > tfoot, > tbody'));","        } else {","            colgroup.empty();","        }","","        for (i = 0, len = columns.length; i < len; ++i) {","","            colgroup.append(template);","","            this._setColumnWidth(i, columns[i].width);","        }","    }","}, true);","","Y.DataTable.ColumnWidths = ColumnWidths;","","Y.Base.mix(Y.DataTable, [ColumnWidths]);","/**","Adds a style `width` setting to an associated `<col>`","element for the column.","","Note, the assigned width will not truncate cell content, and","it will not preserve the configured width if doing so would","compromise either the instance's `width` configuration or","the natural width of the table's containing DOM elements.","","If absolute widths are required, it can be accomplished with","some custom CSS and the use of a `cellTemplate`, or","`formatter`.  ","","See the description of ","[datatable-column-widths](DataTable.ColumnWidths.html) ","for an example of how to do this.","","    { key: 'a', width: '400px' },","    { key: 'b', width: '10em' }","","@property width","@type String","@for DataTable.Column"," */","","","}, '3.14.0', {\"requires\": [\"datatable-base\"]});","","}());"]};
}
var __cov_ZS206IWDiOe_EnLP4zuKug = __coverage__['build/datatable-column-widths/datatable-column-widths.js'];
__cov_ZS206IWDiOe_EnLP4zuKug.s['1']++;YUI.add('datatable-column-widths',function(Y,NAME){__cov_ZS206IWDiOe_EnLP4zuKug.f['1']++;__cov_ZS206IWDiOe_EnLP4zuKug.s['2']++;var isNumber=Y.Lang.isNumber,arrayIndex=Y.Array.indexOf;__cov_ZS206IWDiOe_EnLP4zuKug.s['3']++;Y.Features.add('table','badColWidth',{test:function(){__cov_ZS206IWDiOe_EnLP4zuKug.f['2']++;__cov_ZS206IWDiOe_EnLP4zuKug.s['4']++;var body=Y.one('body'),node,broken;__cov_ZS206IWDiOe_EnLP4zuKug.s['5']++;if(body){__cov_ZS206IWDiOe_EnLP4zuKug.b['1'][0]++;__cov_ZS206IWDiOe_EnLP4zuKug.s['6']++;node=body.insertBefore('<table style="position:absolute;visibility:hidden;border:0 none">'+'<colgroup><col style="width:9px"></colgroup>'+'<tbody><tr>'+'<td style="'+'padding:0 4px;'+'font:normal 2px/2px arial;'+'border:0 none">'+'.'+'</td></tr></tbody>'+'</table>',body.get('firstChild'));__cov_ZS206IWDiOe_EnLP4zuKug.s['7']++;broken=node.one('td').getComputedStyle('width')!=='1px';__cov_ZS206IWDiOe_EnLP4zuKug.s['8']++;node.remove(true);}else{__cov_ZS206IWDiOe_EnLP4zuKug.b['1'][1]++;}__cov_ZS206IWDiOe_EnLP4zuKug.s['9']++;return broken;}});__cov_ZS206IWDiOe_EnLP4zuKug.s['10']++;function ColumnWidths(){__cov_ZS206IWDiOe_EnLP4zuKug.f['3']++;}__cov_ZS206IWDiOe_EnLP4zuKug.s['11']++;Y.mix(ColumnWidths.prototype,{COL_TEMPLATE:'<col/>',COLGROUP_TEMPLATE:'<colgroup/>',setColumnWidth:function(id,width){__cov_ZS206IWDiOe_EnLP4zuKug.f['4']++;__cov_ZS206IWDiOe_EnLP4zuKug.s['12']++;var col=this.getColumn(id),index=(__cov_ZS206IWDiOe_EnLP4zuKug.b['2'][0]++,col)&&(__cov_ZS206IWDiOe_EnLP4zuKug.b['2'][1]++,arrayIndex(this._displayColumns,col));__cov_ZS206IWDiOe_EnLP4zuKug.s['13']++;if(index>-1){__cov_ZS206IWDiOe_EnLP4zuKug.b['3'][0]++;__cov_ZS206IWDiOe_EnLP4zuKug.s['14']++;if(isNumber(width)){__cov_ZS206IWDiOe_EnLP4zuKug.b['4'][0]++;__cov_ZS206IWDiOe_EnLP4zuKug.s['15']++;width+='px';}else{__cov_ZS206IWDiOe_EnLP4zuKug.b['4'][1]++;}__cov_ZS206IWDiOe_EnLP4zuKug.s['16']++;col.width=width;__cov_ZS206IWDiOe_EnLP4zuKug.s['17']++;this._setColumnWidth(index,width);}else{__cov_ZS206IWDiOe_EnLP4zuKug.b['3'][1]++;}__cov_ZS206IWDiOe_EnLP4zuKug.s['18']++;return this;},_createColumnGroup:function(){__cov_ZS206IWDiOe_EnLP4zuKug.f['5']++;__cov_ZS206IWDiOe_EnLP4zuKug.s['19']++;return Y.Node.create(this.COLGROUP_TEMPLATE);},initializer:function(){__cov_ZS206IWDiOe_EnLP4zuKug.f['6']++;__cov_ZS206IWDiOe_EnLP4zuKug.s['20']++;this.after(['renderView','columnsChange'],this._uiSetColumnWidths);},_setColumnWidth:function(colIndex,width){__cov_ZS206IWDiOe_EnLP4zuKug.f['7']++;__cov_ZS206IWDiOe_EnLP4zuKug.s['21']++;var colgroup=this._colgroupNode,col=(__cov_ZS206IWDiOe_EnLP4zuKug.b['5'][0]++,colgroup)&&(__cov_ZS206IWDiOe_EnLP4zuKug.b['5'][1]++,colgroup.all('col').item(colIndex)),cell,getCStyle;__cov_ZS206IWDiOe_EnLP4zuKug.s['22']++;if(col){__cov_ZS206IWDiOe_EnLP4zuKug.b['6'][0]++;__cov_ZS206IWDiOe_EnLP4zuKug.s['23']++;if((__cov_ZS206IWDiOe_EnLP4zuKug.b['8'][0]++,width)&&(__cov_ZS206IWDiOe_EnLP4zuKug.b['8'][1]++,isNumber(width))){__cov_ZS206IWDiOe_EnLP4zuKug.b['7'][0]++;__cov_ZS206IWDiOe_EnLP4zuKug.s['24']++;width+='px';}else{__cov_ZS206IWDiOe_EnLP4zuKug.b['7'][1]++;}__cov_ZS206IWDiOe_EnLP4zuKug.s['25']++;col.setStyle('width',width);__cov_ZS206IWDiOe_EnLP4zuKug.s['26']++;if((__cov_ZS206IWDiOe_EnLP4zuKug.b['10'][0]++,width)&&(__cov_ZS206IWDiOe_EnLP4zuKug.b['10'][1]++,Y.Features.test('table','badColWidth'))){__cov_ZS206IWDiOe_EnLP4zuKug.b['9'][0]++;__cov_ZS206IWDiOe_EnLP4zuKug.s['27']++;cell=this.getCell([0,colIndex]);__cov_ZS206IWDiOe_EnLP4zuKug.s['28']++;if(cell){__cov_ZS206IWDiOe_EnLP4zuKug.b['11'][0]++;__cov_ZS206IWDiOe_EnLP4zuKug.s['29']++;getCStyle=function(prop){__cov_ZS206IWDiOe_EnLP4zuKug.f['8']++;__cov_ZS206IWDiOe_EnLP4zuKug.s['30']++;return(__cov_ZS206IWDiOe_EnLP4zuKug.b['12'][0]++,parseInt(cell.getComputedStyle(prop),10))||(__cov_ZS206IWDiOe_EnLP4zuKug.b['12'][1]++,0);};__cov_ZS206IWDiOe_EnLP4zuKug.s['31']++;col.setStyle('width',parseInt(width,10)-getCStyle('paddingLeft')-getCStyle('paddingRight')-getCStyle('borderLeftWidth')-getCStyle('borderRightWidth')+'px');}else{__cov_ZS206IWDiOe_EnLP4zuKug.b['11'][1]++;}}else{__cov_ZS206IWDiOe_EnLP4zuKug.b['9'][1]++;}}else{__cov_ZS206IWDiOe_EnLP4zuKug.b['6'][1]++;}},_uiSetColumnWidths:function(){__cov_ZS206IWDiOe_EnLP4zuKug.f['9']++;__cov_ZS206IWDiOe_EnLP4zuKug.s['32']++;if(!this.view){__cov_ZS206IWDiOe_EnLP4zuKug.b['13'][0]++;__cov_ZS206IWDiOe_EnLP4zuKug.s['33']++;return;}else{__cov_ZS206IWDiOe_EnLP4zuKug.b['13'][1]++;}__cov_ZS206IWDiOe_EnLP4zuKug.s['34']++;var template=this.COL_TEMPLATE,colgroup=this._colgroupNode,columns=this._displayColumns,i,len;__cov_ZS206IWDiOe_EnLP4zuKug.s['35']++;if(!colgroup){__cov_ZS206IWDiOe_EnLP4zuKug.b['14'][0]++;__cov_ZS206IWDiOe_EnLP4zuKug.s['36']++;colgroup=this._colgroupNode=this._createColumnGroup();__cov_ZS206IWDiOe_EnLP4zuKug.s['37']++;this._tableNode.insertBefore(colgroup,this._tableNode.one('> thead, > tfoot, > tbody'));}else{__cov_ZS206IWDiOe_EnLP4zuKug.b['14'][1]++;__cov_ZS206IWDiOe_EnLP4zuKug.s['38']++;colgroup.empty();}__cov_ZS206IWDiOe_EnLP4zuKug.s['39']++;for(i=0,len=columns.length;i<len;++i){__cov_ZS206IWDiOe_EnLP4zuKug.s['40']++;colgroup.append(template);__cov_ZS206IWDiOe_EnLP4zuKug.s['41']++;this._setColumnWidth(i,columns[i].width);}}},true);__cov_ZS206IWDiOe_EnLP4zuKug.s['42']++;Y.DataTable.ColumnWidths=ColumnWidths;__cov_ZS206IWDiOe_EnLP4zuKug.s['43']++;Y.Base.mix(Y.DataTable,[ColumnWidths]);},'3.14.0',{'requires':['datatable-base']});
