/*
YUI 3.14.0 (build a01e97d)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/event-contextmenu/event-contextmenu.js']) {
   __coverage__['build/event-contextmenu/event-contextmenu.js'] = {"path":"build/event-contextmenu/event-contextmenu.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0,0,0,0,0,0],"6":[0,0,0,0,0],"7":[0,0],"8":[0,0,0,0,0],"9":[0,0],"10":[0,0,0,0,0,0],"11":[0,0],"12":[0,0],"13":[0,0,0,0],"14":[0,0],"15":[0,0,0,0,0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":29},"end":{"line":1,"column":48}}},"2":{"name":"(anonymous_2)","line":40,"loc":{"start":{"line":40,"column":12},"end":{"line":40,"column":60}}},"3":{"name":"(anonymous_3)","line":44,"loc":{"start":{"line":44,"column":55},"end":{"line":44,"column":68}}},"4":{"name":"(anonymous_4)","line":67,"loc":{"start":{"line":67,"column":69},"end":{"line":67,"column":82}}},"5":{"name":"(anonymous_5)","line":174,"loc":{"start":{"line":174,"column":16},"end":{"line":174,"column":56}}},"6":{"name":"(anonymous_6)","line":176,"loc":{"start":{"line":176,"column":42},"end":{"line":176,"column":60}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":192,"column":62}},"2":{"start":{"line":23,"column":0},"end":{"line":182,"column":6}},"3":{"start":{"line":42,"column":12},"end":{"line":42,"column":29}},"4":{"start":{"line":44,"column":12},"end":{"line":64,"column":23}},"5":{"start":{"line":49,"column":16},"end":{"line":49,"column":35}},"6":{"start":{"line":51,"column":16},"end":{"line":52,"column":41}},"7":{"start":{"line":54,"column":16},"end":{"line":60,"column":17}},"8":{"start":{"line":55,"column":20},"end":{"line":55,"column":45}},"9":{"start":{"line":56,"column":20},"end":{"line":56,"column":45}},"10":{"start":{"line":57,"column":20},"end":{"line":57,"column":41}},"11":{"start":{"line":58,"column":20},"end":{"line":58,"column":41}},"12":{"start":{"line":59,"column":20},"end":{"line":59,"column":41}},"13":{"start":{"line":62,"column":16},"end":{"line":62,"column":33}},"14":{"start":{"line":67,"column":12},"end":{"line":168,"column":24}},"15":{"start":{"line":69,"column":16},"end":{"line":90,"column":22}},"16":{"start":{"line":93,"column":16},"end":{"line":166,"column":17}},"17":{"start":{"line":108,"column":20},"end":{"line":110,"column":21}},"18":{"start":{"line":109,"column":24},"end":{"line":109,"column":43}},"19":{"start":{"line":112,"column":20},"end":{"line":112,"column":43}},"20":{"start":{"line":113,"column":20},"end":{"line":113,"column":30}},"21":{"start":{"line":114,"column":20},"end":{"line":114,"column":30}},"22":{"start":{"line":115,"column":20},"end":{"line":115,"column":47}},"23":{"start":{"line":116,"column":20},"end":{"line":116,"column":47}},"24":{"start":{"line":120,"column":20},"end":{"line":123,"column":21}},"25":{"start":{"line":121,"column":24},"end":{"line":121,"column":73}},"26":{"start":{"line":122,"column":24},"end":{"line":122,"column":74}},"27":{"start":{"line":125,"column":20},"end":{"line":125,"column":46}},"28":{"start":{"line":126,"column":20},"end":{"line":126,"column":46}},"29":{"start":{"line":133,"column":20},"end":{"line":140,"column":21}},"30":{"start":{"line":134,"column":24},"end":{"line":139,"column":26}},"31":{"start":{"line":156,"column":20},"end":{"line":164,"column":21}},"32":{"start":{"line":158,"column":24},"end":{"line":158,"column":44}},"33":{"start":{"line":159,"column":24},"end":{"line":159,"column":44}},"34":{"start":{"line":160,"column":24},"end":{"line":160,"column":40}},"35":{"start":{"line":161,"column":24},"end":{"line":161,"column":40}},"36":{"start":{"line":163,"column":24},"end":{"line":163,"column":41}},"37":{"start":{"line":170,"column":12},"end":{"line":170,"column":44}},"38":{"start":{"line":176,"column":12},"end":{"line":178,"column":15}},"39":{"start":{"line":177,"column":16},"end":{"line":177,"column":32}},"40":{"start":{"line":185,"column":0},"end":{"line":185,"column":24}},"41":{"start":{"line":186,"column":0},"end":{"line":186,"column":34}},"42":{"start":{"line":189,"column":0},"end":{"line":189,"column":40}}},"branchMap":{"1":{"line":54,"type":"if","locations":[{"start":{"line":54,"column":16},"end":{"line":54,"column":16}},{"start":{"line":54,"column":16},"end":{"line":54,"column":16}}]},"2":{"line":67,"type":"cond-expr","locations":[{"start":{"line":67,"column":39},"end":{"line":67,"column":49}},{"start":{"line":67,"column":52},"end":{"line":67,"column":56}}]},"3":{"line":72,"type":"binary-expr","locations":[{"start":{"line":72,"column":32},"end":{"line":72,"column":40}},{"start":{"line":72,"column":44},"end":{"line":72,"column":58}}]},"4":{"line":73,"type":"binary-expr","locations":[{"start":{"line":73,"column":31},"end":{"line":73,"column":36}},{"start":{"line":73,"column":40},"end":{"line":73,"column":53}}]},"5":{"line":76,"type":"binary-expr","locations":[{"start":{"line":76,"column":49},"end":{"line":76,"column":54}},{"start":{"line":76,"column":59},"end":{"line":76,"column":65}},{"start":{"line":76,"column":69},"end":{"line":76,"column":74}},{"start":{"line":76,"column":79},"end":{"line":76,"column":86}},{"start":{"line":76,"column":90},"end":{"line":76,"column":98}},{"start":{"line":76,"column":102},"end":{"line":76,"column":110}},{"start":{"line":76,"column":114},"end":{"line":76,"column":118}}]},"6":{"line":80,"type":"binary-expr","locations":[{"start":{"line":80,"column":40},"end":{"line":80,"column":45}},{"start":{"line":80,"column":49},"end":{"line":80,"column":54}},{"start":{"line":80,"column":58},"end":{"line":80,"column":65}},{"start":{"line":80,"column":69},"end":{"line":80,"column":77}},{"start":{"line":80,"column":81},"end":{"line":80,"column":85}}]},"7":{"line":93,"type":"if","locations":[{"start":{"line":93,"column":16},"end":{"line":93,"column":16}},{"start":{"line":93,"column":16},"end":{"line":93,"column":16}}]},"8":{"line":93,"type":"binary-expr","locations":[{"start":{"line":93,"column":21},"end":{"line":93,"column":26}},{"start":{"line":93,"column":31},"end":{"line":93,"column":39}},{"start":{"line":93,"column":43},"end":{"line":93,"column":50}},{"start":{"line":94,"column":25},"end":{"line":94,"column":50}},{"start":{"line":94,"column":54},"end":{"line":94,"column":70}}]},"9":{"line":108,"type":"if","locations":[{"start":{"line":108,"column":20},"end":{"line":108,"column":20}},{"start":{"line":108,"column":20},"end":{"line":108,"column":20}}]},"10":{"line":108,"type":"binary-expr","locations":[{"start":{"line":108,"column":26},"end":{"line":108,"column":28}},{"start":{"line":108,"column":33},"end":{"line":108,"column":38}},{"start":{"line":108,"column":43},"end":{"line":108,"column":48}},{"start":{"line":108,"column":52},"end":{"line":108,"column":57}},{"start":{"line":108,"column":64},"end":{"line":108,"column":72}},{"start":{"line":108,"column":77},"end":{"line":108,"column":93}}]},"11":{"line":120,"type":"if","locations":[{"start":{"line":120,"column":20},"end":{"line":120,"column":20}},{"start":{"line":120,"column":20},"end":{"line":120,"column":20}}]},"12":{"line":133,"type":"if","locations":[{"start":{"line":133,"column":20},"end":{"line":133,"column":20}},{"start":{"line":133,"column":20},"end":{"line":133,"column":20}}]},"13":{"line":133,"type":"binary-expr","locations":[{"start":{"line":133,"column":24},"end":{"line":133,"column":31}},{"start":{"line":133,"column":36},"end":{"line":133,"column":41}},{"start":{"line":133,"column":45},"end":{"line":133,"column":51}},{"start":{"line":133,"column":55},"end":{"line":133,"column":63}}]},"14":{"line":156,"type":"if","locations":[{"start":{"line":156,"column":20},"end":{"line":156,"column":20}},{"start":{"line":156,"column":20},"end":{"line":156,"column":20}}]},"15":{"line":156,"type":"binary-expr","locations":[{"start":{"line":156,"column":26},"end":{"line":156,"column":28}},{"start":{"line":156,"column":33},"end":{"line":156,"column":38}},{"start":{"line":156,"column":43},"end":{"line":156,"column":48}},{"start":{"line":156,"column":52},"end":{"line":156,"column":57}},{"start":{"line":156,"column":64},"end":{"line":156,"column":72}},{"start":{"line":156,"column":77},"end":{"line":156,"column":82}}]}},"code":["(function () { YUI.add('event-contextmenu', function (Y, NAME) {","","/**"," * Provides extended keyboard support for the \"contextmenu\" event such that:"," * <ul>"," * <li>The browser's default context menu is suppressed regardless of how the event is triggered.</li>"," * <li>On Windows the \"contextmenu\" event is fired consistently regardless of whether the user"," * pressed the Menu key or Shift + F10.</li>"," * <li>When the \"contextmenu\" event is fired via the keyboard, the pageX, pageY, clientX and clientY"," * properties reference the center of the event target. This makes it easy for \"contextmenu\" event listeners"," * to position an overlay in response to the event by not having to worry about special handling of the x"," * and y coordinates based on the device that fired the event.</li>"," * <li>For Webkit and Gecko on the Mac it enables the use of the Shift + Control + Option + M keyboard"," * shortcut to fire the \"contextmenu\" event, which (by default) is only available when VoiceOver"," * (the screen reader on the Mac) is enabled.</li>"," * <li>For Opera on the Mac it ensures the \"contextmenu\" event is fired when the user presses"," * Shift + Command + M (Opera's context menu keyboard shortcut).</li>"," * </ul>"," * @module event-contextmenu"," * @requires event"," */","","var Event = Y.Event,","    DOM = Y.DOM,","    UA = Y.UA,","    OS = Y.UA.os,","","    ie = UA.ie,","    gecko = UA.gecko,","    webkit = UA.webkit,","    opera = UA.opera,","","    isWin = (OS === \"windows\"),","    isMac = (OS === \"macintosh\"),","","    eventData = {},","","    conf = {","","        on: function (node, subscription, notifier, filter) {","","            var handles = [];","","            handles.push(Event._attach([\"contextmenu\", function (e) {","","                // Any developer listening for the \"contextmenu\" event is likely","                // going to call preventDefault() to prevent the display of","                // the browser's context menu. So, you know, save them a step.","                e.preventDefault();","","                var id = Y.stamp(node),","                    data = eventData[id];","","                if (data) {","                    e.clientX = data.clientX;","                    e.clientY = data.clientY;","                    e.pageX = data.pageX;","                    e.pageY = data.pageY;","                    delete eventData[id];","                }","","                notifier.fire(e);","","            }, node]));","","","            handles.push(node[filter ? \"delegate\" : \"on\"](\"keydown\", function (e) {","","                var target = this.getDOMNode(),","                    shiftKey = e.shiftKey,","                    keyCode = e.keyCode,","                    shiftF10 = (shiftKey && keyCode == 121),","                    menuKey = (isWin && keyCode == 93),","                    ctrlKey = e.ctrlKey,","                    mKey = (keyCode === 77),","                    macWebkitAndGeckoShortcut = (isMac && (webkit || gecko) && ctrlKey && shiftKey && e.altKey && mKey),","","                    // Note: The context menu keyboard shortcut for Opera on the Mac is Shift + Cmd (metaKey) + M,","                    // but e.metaKey is false for Opera, and Opera sets e.ctrlKey to true instead.","                    macOperaShortcut = (isMac && opera && ctrlKey && shiftKey && mKey),","","                    clientX = 0,","                    clientY = 0,","                    scrollX,","                    scrollY,","                    pageX,","                    pageY,","                    xy,","                    x,","                    y;","","","                if ((isWin && (shiftF10 || menuKey)) ||","                        (macWebkitAndGeckoShortcut || macOperaShortcut)) {","","                    // Need to call preventDefault() here b/c:","                    // 1) To prevent IE's menubar from gaining focus when the","                    // user presses Shift + F10","                    // 2) In Firefox and Opera for Win, Shift + F10 will display a","                    // context menu, but won't fire the \"contextmenu\" event. So, need","                    // to call preventDefault() to prevent the display of the","                    // browser's context menu","                    // 3) For Opera on the Mac the context menu keyboard shortcut","                    // (Shift + Cmd + M) will display a context menu, but like Firefox","                    // and Opera on windows, Opera doesn't fire a \"contextmenu\" event,","                    // so preventDefault() is just used to supress Opera's","                    // default context menu.","                    if (((ie || (isWin && (gecko || opera))) && shiftF10) || macOperaShortcut) {","                        e.preventDefault();","                    }","","                    xy = DOM.getXY(target);","                    x = xy[0];","                    y = xy[1];","                    scrollX = DOM.docScrollX();","                    scrollY = DOM.docScrollY();","","                    // Protect against instances where xy and might not be returned,","                    // for example if the target is the document.","                    if (!Y.Lang.isUndefined(x)) {","                        clientX = (x + (target.offsetWidth/2)) - scrollX;","                        clientY = (y + (target.offsetHeight/2)) - scrollY;","                    }","","                    pageX = clientX + scrollX;","                    pageY = clientY + scrollY;","","                    // When the \"contextmenu\" event is fired from the keyboard","                    // clientX, clientY, pageX or pageY aren't set to useful","                    // values. So, we follow Safari's model here of setting","                    // the x & x coords to the center of the event target.","","                    if (menuKey || (isWin && webkit && shiftF10)) {","                        eventData[Y.stamp(node)] = {","                            clientX: clientX,","                            clientY: clientY,","                            pageX: pageX,","                            pageY: pageY","                        };","                    }","","                    // Don't need to call notifier.fire(e) when the Menu key","                    // is pressed as it fires the \"contextmenu\" event by default.","                    //","                    // In IE the call to preventDefault() for Shift + F10","                    // prevents the \"contextmenu\" event from firing, so we need","                    // to call notifier.fire(e)","                    //","                    // Need to also call notifier.fire(e) for Gecko and Opera since","                    // neither Shift + F10 or Shift + Cmd + M fire the \"contextmenu\" event.","                    //","                    // Lastly, also need to call notifier.fire(e) for all Mac browsers","                    // since neither Shift + Ctrl + Option + M (Webkit and Gecko) or","                    // Shift + Command + M (Opera) fire the \"contextmenu\" event.","","                    if (((ie || (isWin && (gecko || opera))) && shiftF10) || isMac) {","","                        e.clientX = clientX;","                        e.clientY = clientY;","                        e.pageX = pageX;","                        e.pageY = pageY;","","                        notifier.fire(e);","                    }","","                }","","            }, filter));","","            subscription._handles = handles;","","        },","","        detach: function (node, subscription, notifier) {","","            Y.each(subscription._handles, function (handle) {","                handle.detach();","            });","","        }","","    };","","","conf.delegate = conf.on;","conf.detachDelegate = conf.detach;","","","Event.define(\"contextmenu\", conf, true);","","","}, '3.14.0', {\"requires\": [\"event-synthetic\", \"dom-screen\"]});","","}());"]};
}
var __cov_aOwv6fW_0MxH6moDodxMgQ = __coverage__['build/event-contextmenu/event-contextmenu.js'];
__cov_aOwv6fW_0MxH6moDodxMgQ.s['1']++;YUI.add('event-contextmenu',function(Y,NAME){__cov_aOwv6fW_0MxH6moDodxMgQ.f['1']++;__cov_aOwv6fW_0MxH6moDodxMgQ.s['2']++;var Event=Y.Event,DOM=Y.DOM,UA=Y.UA,OS=Y.UA.os,ie=UA.ie,gecko=UA.gecko,webkit=UA.webkit,opera=UA.opera,isWin=OS==='windows',isMac=OS==='macintosh',eventData={},conf={on:function(node,subscription,notifier,filter){__cov_aOwv6fW_0MxH6moDodxMgQ.f['2']++;__cov_aOwv6fW_0MxH6moDodxMgQ.s['3']++;var handles=[];__cov_aOwv6fW_0MxH6moDodxMgQ.s['4']++;handles.push(Event._attach(['contextmenu',function(e){__cov_aOwv6fW_0MxH6moDodxMgQ.f['3']++;__cov_aOwv6fW_0MxH6moDodxMgQ.s['5']++;e.preventDefault();__cov_aOwv6fW_0MxH6moDodxMgQ.s['6']++;var id=Y.stamp(node),data=eventData[id];__cov_aOwv6fW_0MxH6moDodxMgQ.s['7']++;if(data){__cov_aOwv6fW_0MxH6moDodxMgQ.b['1'][0]++;__cov_aOwv6fW_0MxH6moDodxMgQ.s['8']++;e.clientX=data.clientX;__cov_aOwv6fW_0MxH6moDodxMgQ.s['9']++;e.clientY=data.clientY;__cov_aOwv6fW_0MxH6moDodxMgQ.s['10']++;e.pageX=data.pageX;__cov_aOwv6fW_0MxH6moDodxMgQ.s['11']++;e.pageY=data.pageY;__cov_aOwv6fW_0MxH6moDodxMgQ.s['12']++;delete eventData[id];}else{__cov_aOwv6fW_0MxH6moDodxMgQ.b['1'][1]++;}__cov_aOwv6fW_0MxH6moDodxMgQ.s['13']++;notifier.fire(e);},node]));__cov_aOwv6fW_0MxH6moDodxMgQ.s['14']++;handles.push(node[filter?(__cov_aOwv6fW_0MxH6moDodxMgQ.b['2'][0]++,'delegate'):(__cov_aOwv6fW_0MxH6moDodxMgQ.b['2'][1]++,'on')]('keydown',function(e){__cov_aOwv6fW_0MxH6moDodxMgQ.f['4']++;__cov_aOwv6fW_0MxH6moDodxMgQ.s['15']++;var target=this.getDOMNode(),shiftKey=e.shiftKey,keyCode=e.keyCode,shiftF10=(__cov_aOwv6fW_0MxH6moDodxMgQ.b['3'][0]++,shiftKey)&&(__cov_aOwv6fW_0MxH6moDodxMgQ.b['3'][1]++,keyCode==121),menuKey=(__cov_aOwv6fW_0MxH6moDodxMgQ.b['4'][0]++,isWin)&&(__cov_aOwv6fW_0MxH6moDodxMgQ.b['4'][1]++,keyCode==93),ctrlKey=e.ctrlKey,mKey=keyCode===77,macWebkitAndGeckoShortcut=(__cov_aOwv6fW_0MxH6moDodxMgQ.b['5'][0]++,isMac)&&((__cov_aOwv6fW_0MxH6moDodxMgQ.b['5'][1]++,webkit)||(__cov_aOwv6fW_0MxH6moDodxMgQ.b['5'][2]++,gecko))&&(__cov_aOwv6fW_0MxH6moDodxMgQ.b['5'][3]++,ctrlKey)&&(__cov_aOwv6fW_0MxH6moDodxMgQ.b['5'][4]++,shiftKey)&&(__cov_aOwv6fW_0MxH6moDodxMgQ.b['5'][5]++,e.altKey)&&(__cov_aOwv6fW_0MxH6moDodxMgQ.b['5'][6]++,mKey),macOperaShortcut=(__cov_aOwv6fW_0MxH6moDodxMgQ.b['6'][0]++,isMac)&&(__cov_aOwv6fW_0MxH6moDodxMgQ.b['6'][1]++,opera)&&(__cov_aOwv6fW_0MxH6moDodxMgQ.b['6'][2]++,ctrlKey)&&(__cov_aOwv6fW_0MxH6moDodxMgQ.b['6'][3]++,shiftKey)&&(__cov_aOwv6fW_0MxH6moDodxMgQ.b['6'][4]++,mKey),clientX=0,clientY=0,scrollX,scrollY,pageX,pageY,xy,x,y;__cov_aOwv6fW_0MxH6moDodxMgQ.s['16']++;if((__cov_aOwv6fW_0MxH6moDodxMgQ.b['8'][0]++,isWin)&&((__cov_aOwv6fW_0MxH6moDodxMgQ.b['8'][1]++,shiftF10)||(__cov_aOwv6fW_0MxH6moDodxMgQ.b['8'][2]++,menuKey))||((__cov_aOwv6fW_0MxH6moDodxMgQ.b['8'][3]++,macWebkitAndGeckoShortcut)||(__cov_aOwv6fW_0MxH6moDodxMgQ.b['8'][4]++,macOperaShortcut))){__cov_aOwv6fW_0MxH6moDodxMgQ.b['7'][0]++;__cov_aOwv6fW_0MxH6moDodxMgQ.s['17']++;if(((__cov_aOwv6fW_0MxH6moDodxMgQ.b['10'][0]++,ie)||(__cov_aOwv6fW_0MxH6moDodxMgQ.b['10'][1]++,isWin)&&((__cov_aOwv6fW_0MxH6moDodxMgQ.b['10'][2]++,gecko)||(__cov_aOwv6fW_0MxH6moDodxMgQ.b['10'][3]++,opera)))&&(__cov_aOwv6fW_0MxH6moDodxMgQ.b['10'][4]++,shiftF10)||(__cov_aOwv6fW_0MxH6moDodxMgQ.b['10'][5]++,macOperaShortcut)){__cov_aOwv6fW_0MxH6moDodxMgQ.b['9'][0]++;__cov_aOwv6fW_0MxH6moDodxMgQ.s['18']++;e.preventDefault();}else{__cov_aOwv6fW_0MxH6moDodxMgQ.b['9'][1]++;}__cov_aOwv6fW_0MxH6moDodxMgQ.s['19']++;xy=DOM.getXY(target);__cov_aOwv6fW_0MxH6moDodxMgQ.s['20']++;x=xy[0];__cov_aOwv6fW_0MxH6moDodxMgQ.s['21']++;y=xy[1];__cov_aOwv6fW_0MxH6moDodxMgQ.s['22']++;scrollX=DOM.docScrollX();__cov_aOwv6fW_0MxH6moDodxMgQ.s['23']++;scrollY=DOM.docScrollY();__cov_aOwv6fW_0MxH6moDodxMgQ.s['24']++;if(!Y.Lang.isUndefined(x)){__cov_aOwv6fW_0MxH6moDodxMgQ.b['11'][0]++;__cov_aOwv6fW_0MxH6moDodxMgQ.s['25']++;clientX=x+target.offsetWidth/2-scrollX;__cov_aOwv6fW_0MxH6moDodxMgQ.s['26']++;clientY=y+target.offsetHeight/2-scrollY;}else{__cov_aOwv6fW_0MxH6moDodxMgQ.b['11'][1]++;}__cov_aOwv6fW_0MxH6moDodxMgQ.s['27']++;pageX=clientX+scrollX;__cov_aOwv6fW_0MxH6moDodxMgQ.s['28']++;pageY=clientY+scrollY;__cov_aOwv6fW_0MxH6moDodxMgQ.s['29']++;if((__cov_aOwv6fW_0MxH6moDodxMgQ.b['13'][0]++,menuKey)||(__cov_aOwv6fW_0MxH6moDodxMgQ.b['13'][1]++,isWin)&&(__cov_aOwv6fW_0MxH6moDodxMgQ.b['13'][2]++,webkit)&&(__cov_aOwv6fW_0MxH6moDodxMgQ.b['13'][3]++,shiftF10)){__cov_aOwv6fW_0MxH6moDodxMgQ.b['12'][0]++;__cov_aOwv6fW_0MxH6moDodxMgQ.s['30']++;eventData[Y.stamp(node)]={clientX:clientX,clientY:clientY,pageX:pageX,pageY:pageY};}else{__cov_aOwv6fW_0MxH6moDodxMgQ.b['12'][1]++;}__cov_aOwv6fW_0MxH6moDodxMgQ.s['31']++;if(((__cov_aOwv6fW_0MxH6moDodxMgQ.b['15'][0]++,ie)||(__cov_aOwv6fW_0MxH6moDodxMgQ.b['15'][1]++,isWin)&&((__cov_aOwv6fW_0MxH6moDodxMgQ.b['15'][2]++,gecko)||(__cov_aOwv6fW_0MxH6moDodxMgQ.b['15'][3]++,opera)))&&(__cov_aOwv6fW_0MxH6moDodxMgQ.b['15'][4]++,shiftF10)||(__cov_aOwv6fW_0MxH6moDodxMgQ.b['15'][5]++,isMac)){__cov_aOwv6fW_0MxH6moDodxMgQ.b['14'][0]++;__cov_aOwv6fW_0MxH6moDodxMgQ.s['32']++;e.clientX=clientX;__cov_aOwv6fW_0MxH6moDodxMgQ.s['33']++;e.clientY=clientY;__cov_aOwv6fW_0MxH6moDodxMgQ.s['34']++;e.pageX=pageX;__cov_aOwv6fW_0MxH6moDodxMgQ.s['35']++;e.pageY=pageY;__cov_aOwv6fW_0MxH6moDodxMgQ.s['36']++;notifier.fire(e);}else{__cov_aOwv6fW_0MxH6moDodxMgQ.b['14'][1]++;}}else{__cov_aOwv6fW_0MxH6moDodxMgQ.b['7'][1]++;}},filter));__cov_aOwv6fW_0MxH6moDodxMgQ.s['37']++;subscription._handles=handles;},detach:function(node,subscription,notifier){__cov_aOwv6fW_0MxH6moDodxMgQ.f['5']++;__cov_aOwv6fW_0MxH6moDodxMgQ.s['38']++;Y.each(subscription._handles,function(handle){__cov_aOwv6fW_0MxH6moDodxMgQ.f['6']++;__cov_aOwv6fW_0MxH6moDodxMgQ.s['39']++;handle.detach();});}};__cov_aOwv6fW_0MxH6moDodxMgQ.s['40']++;conf.delegate=conf.on;__cov_aOwv6fW_0MxH6moDodxMgQ.s['41']++;conf.detachDelegate=conf.detach;__cov_aOwv6fW_0MxH6moDodxMgQ.s['42']++;Event.define('contextmenu',conf,true);},'3.14.0',{'requires':['event-synthetic','dom-screen']});
