define(["require", "exports", "ps_jquery_utils", "templateMgr"], function(require, exports, __psju__, __templateMgr__) {
    "use strict";
    var psju = __psju__;

    psju;
    var templateMgr = __templateMgr__;

    templateMgr;
    var metatypes = {
    };
    var format = psju.format;
    var StaticInfo;
    (function (StaticInfo) {
        var MQInfo = (function () {
            function MQInfo() {
                throw new Error("Cannot new this class");
            }
            MQInfo.mathquillTypes = [
                "Option[Term]", 
                "Term", 
                "FOLFormula"
            ];
            return MQInfo;
        })();
        StaticInfo.MQInfo = MQInfo;        
    })(StaticInfo || (StaticInfo = {}));
    var AbstractVal = (function () {
        function AbstractVal(typeName, subTypes) {
            this.typeName = typeName;
            this.subTypes = subTypes;
        }
        AbstractVal.prototype.mkDiv = function () {
            var template = templateMgr.getTemplate("abstractVal");
            var retVal = template(this);
            return retVal;
        };
        return AbstractVal;
    })();
    exports.AbstractVal = AbstractVal;    
    var PrimitiveVal = (function () {
        function PrimitiveVal(typeName, value) {
            this.typeName = typeName;
            this.value = value;
            this.__ps_cons = 'PrimitiveVal';
            this.isMathQuillType = $.inArray(this.typeName, StaticInfo.MQInfo.mathquillTypes) > -1;
        }
        PrimitiveVal.prototype.mkDiv = function () {
            var template = templateMgr.getTemplate("primitiveVal");
            var retVal = template(this);
            if(!retVal) {
                throw new Error("template could not be applied");
            }
            return retVal;
        };
        return PrimitiveVal;
    })();
    exports.PrimitiveVal = PrimitiveVal;    
    var CompositeVal = (function () {
        function CompositeVal(typeName, fields, fieldVals) {
            this.typeName = typeName;
            this.fields = fields;
            this.fieldVals = fieldVals;
            this.__ps_cons = 'CompositeVal';
        }
        CompositeVal.prototype.getField = function (fname) {
            var result = $.grep(this.fieldVals, function (fv) {
                return fv.fname == fname;
            });
            return result[0];
        };
        CompositeVal.prototype.mkDiv = function () {
            var fieldTypeDivs = [];
            var fields = this.fields;
            for(var i = 0; i < fields.length; i++) {
                var fieldType = fields[i];
                fieldTypeDivs.push(fieldType.mkDiv());
            }
            var template = templateMgr.getTemplate("compositeVal");
            var retVal = template(jQuery.extend({
                "fieldTypeDivs": fieldTypeDivs
            }, this));
            if(!retVal) {
                throw new Error("template could not be applied");
            }
            return retVal;
        };
        return CompositeVal;
    })();
    exports.CompositeVal = CompositeVal;    
    var FieldVal = (function () {
        function FieldVal(fname, ftype, fval) {
            this.fname = fname;
            this.ftype = ftype;
            this.fval = fval;
            this.__ps_cons = 'FieldVal';
        }
        FieldVal.prototype.mkDiv = function () {
            var fieldTypeObj = exports.getType(this.ftype);
            var ftypeDiv = exports.mkTypeDiv(fieldTypeObj);
            var template = templateMgr.getTemplate("fieldVal");
            var retVal = template(jQuery.extend({
                "ftypeDiv": ftypeDiv
            }, this));
            if(!retVal) {
                throw new Error("template could not be applied");
            }
            return retVal;
        };
        return FieldVal;
    })();
    exports.FieldVal = FieldVal;    
    exports.collectionValsList = [
        "List", 
        "Tuple"
    ];
    var ListVal = (function () {
        function ListVal(paramType, items) {
            this.paramType = paramType;
            this.items = items;
            this.__ps_cons = 'ListVal';
        }
        ListVal.prototype.mkDiv = function () {
            var dummyVal = exports.getType(this.paramType);
            var paramDiv = exports.mkTypeDiv(dummyVal);
            var template = templateMgr.getTemplate("listVal");
            var retVal = template({
                "paramDiv": paramDiv
            });
            if(!retVal) {
                throw new Error("template could not be applied");
            }
            return retVal;
        };
        return ListVal;
    })();
    exports.ListVal = ListVal;    
    var TupleVal = (function () {
        function TupleVal(paramTypes, items) {
            this.paramTypes = paramTypes;
            this.items = items;
            this.__ps_cons = 'TupleVal';
        }
        TupleVal.prototype.mkDiv = function () {
            var itemContentDivs = _.map(this.paramTypes, function (paramType) {
                var dummyVal = exports.getType(paramType);
                var itemContentDiv = exports.mkTypeDiv(dummyVal);
                return itemContentDiv;
            });
            var template = templateMgr.getTemplate("tupleVal");
            var retVal = template({
                "itemContentDivs": itemContentDivs
            });
            if(!retVal) {
                throw new Error("template could not be applied");
            }
            return retVal;
        };
        return TupleVal;
    })();
    exports.TupleVal = TupleVal;    
    exports.absValDb = {
    };
    exports.absValDb["Tactic"] = new AbstractVal("Tactic", [
        "stepIntoUnknownProgIdx", 
        "stepIntoUnknownProgId", 
        "replaceFormula", 
        "retValTactic", 
        "rcvInPost", 
        "rtvInPost", 
        "deleteConjunct", 
        "assumeAssignment", 
        "assumeSkip", 
        "stepOut", 
        "assignmentDerivation", 
        "guessExprValues", 
        "applyHint", 
        "stepOutAll", 
        "initTactic"
    ]);
    exports.primitiveValDb = {
    };
    exports.primitiveValDb["FOLFormula"] = new PrimitiveVal("FOLFormula");
    exports.primitiveValDb["Option[Term]"] = new PrimitiveVal("Option[Term]");
    exports.primitiveValDb["Var"] = new PrimitiveVal("Var");
    exports.primitiveValDb["Integer"] = new PrimitiveVal("Integer");
    exports.primitiveValDb["String"] = new PrimitiveVal("String");
    exports.compositeValDb = {
    };
    var compArr = [
        [
            "rootTactic", 
            [
                "tactic", 
                "Tactic"
            ]
        ], 
        [
            "stepIntoUnknownProgIdx", 
            [
                "idx", 
                "Integer"
            ]
        ], 
        [
            "stepIntoUnknownProgId", 
            [
                "id", 
                "Integer"
            ]
        ], 
        [
            "replaceFormula", 
            [
                "newf", 
                "FOLFormula"
            ]
        ], 
        [
            "retValTactic", 
            [
                "initTerm", 
                "Option[Term]"
            ]
        ], 
        [
            "rcvInPost", 
            [
                "const0", 
                "Var"
            ], 
            [
                "initValue0", 
                "Term"
            ], 
            [
                "bounds", 
                "FOLFormula"
            ]
        ], 
        [
            "rtvInPost", 
            [
                "const0", 
                "Term"
            ], 
            [
                "variable0", 
                "Var"
            ], 
            [
                "initValue0", 
                "Term"
            ], 
            [
                "bounds", 
                "FOLFormula"
            ]
        ], 
        [
            "deleteConjunct", 
            [
                "conjuct", 
                "FOLFormula"
            ], 
            [
                "variant", 
                "Term"
            ]
        ], 
        [
            "assumeAssignment", 
            [
                "lhsRhsTuples", 
                "List[(Var, Term)]"
            ]
        ], 
        [
            "assignmentDerivation", 
            [
                "lhsVars", 
                "List[Var]"
            ]
        ], 
        [
            "assumeSkip"
        ], 
        [
            "stepOut"
        ], 
        [
            "guessExprValues", 
            [
                "primedVarTermList", 
                "List[(Var, Term)]"
            ]
        ], 
        [
            "applyHint", 
            [
                "antecedents", 
                "List[FOLFormula]"
            ], 
            [
                "consequents", 
                "List[FOLFormula]"
            ]
        ], 
        [
            "stepOutAll"
        ], 
        [
            "initTactic", 
            [
                "name", 
                "String"
            ], 
            [
                'params', 
                "List[Var]"
            ], 
            [
                "retVar", 
                "String"
            ], 
            [
                "retType", 
                "String"
            ], 
            [
                "preF", 
                "FOLFormula"
            ], 
            [
                "postF", 
                "FOLFormula"
            ]
        ]
    ];
    for(var i = 0; i < compArr.length; i++) {
        var typeName = compArr[i][0];
        var fieldVars = [];
        for(var j = 1; j < compArr[i].length; j++) {
            var fname = compArr[i][j][0];
            var ftype = compArr[i][j][1];
            fieldVars.push(new FieldVal(fname, ftype));
        }
        exports.compositeValDb[typeName] = new CompositeVal(typeName, fieldVars);
    }
    exports.getType = function (typeStr) {
        var retVal;
        if(typeStr in exports.absValDb) {
            return exports.absValDb[typeStr];
        }
        if(typeStr in exports.compositeValDb) {
            return exports.compositeValDb[typeStr];
        }
        if(typeStr in exports.primitiveValDb) {
            return exports.primitiveValDb[typeStr];
        }
        var res = typeStr.match(/^List\[(.*)\]$/);
        if(res != undefined) {
            var paramType = res[1];
            retVal = new ListVal(paramType, []);
            return retVal;
        }
        var res = typeStr.match(/^\((.*)\)$/);
        if(res != undefined) {
            var tpeArray = res[1].split(", ");
            retVal = new TupleVal(tpeArray, []);
            return retVal;
        }
        throw new Error("typeStr " + typeStr + " is not recognized.");
    };
    exports.mkTypeDiv = function (type) {
        var retVal = "";
        if(type.typeName in exports.primitiveValDb) {
            retVal = type.mkDiv();
        } else if(type.typeName in exports.absValDb) {
            retVal = type.mkDiv();
        } else if(type.typeName in exports.compositeValDb) {
            retVal = type.mkDiv();
        } else if(type.__ps_cons === "ListVal" || type.__ps_cons === "TupleVal") {
            retVal = type.mkDiv();
        }
        if(!retVal) {
            throw new Error("mkTypeDiv failed");
        }
        return retVal;
    };
})
//@ sourceMappingURL=metatypes.js.map
