// Stores the meta types and type repositories.
/// <reference path="typings/underscore/underscore.d.ts" />

"use strict";
//var $ = jQuery = require("jquery-1.7.1.min");
//var psDerivation = require("ps_derivation");
//require("lib/underscore-min");
//var psJqueryUtils = require("ps_jquery_utils");
//var pswebJqueryLayout = require("psweb.jquery.layout");
//var mathquill = require("lib/mathquill/mathquill");
//var jqueryHotkeys = require("lib/jquery.hotkeys");
//var jqueryUi = require("lib/jquery-ui-1.10.0.custom");
//var hydrateMod = require("lib/Hydrate");
//var templates = require("lib/text!templates/_tacticInputDivs.tpl.html");

import psju = module("ps_jquery_utils"); psju;
import templateMgr = module("templateMgr"); templateMgr;

var metatypes = {};
var format = psju.format;

module StaticInfo {
    export class MQInfo {
        constructor() {
            throw new Error("Cannot new this class");
        }
        static mathquillTypes = ["Option[Term]", "Term", "FOLFormula"];
    }
}

//AbstractVal, PrimitiveVal and CompositeType are all disjoint	
export class AbstractVal {
    constructor(public typeName, public subTypes) {
    }
    mkDiv() {
        var template = templateMgr.getTemplate("abstractVal");
        var retVal = template(this);
        return retVal;
    }
}

export class PrimitiveVal  {
    __ps_cons: any;
    isMathQuillType;
    constructor(public typeName, public value?) {
        this.__ps_cons = 'PrimitiveVal';
        this.isMathQuillType = $.inArray(this.typeName, StaticInfo.MQInfo.mathquillTypes) > -1;
    }
    mkDiv() {
        var template = templateMgr.getTemplate("primitiveVal");
        var retVal = template(this);
        if (!retVal) throw new Error("template could not be applied");
        return retVal;
    }
}

export class CompositeVal {
    __ps_cons: any;
    constructor(public typeName/*:String*/, public fields/*:FieldType[]*/, public fieldVals?/*FieldVal[]*/) {
        this.__ps_cons = 'CompositeVal';
    }
    getField(fname) {
        var result = $.grep(this.fieldVals, function (fv) { return fv.fname == fname; });
        return result[0];
    }
    mkDiv() {
        var fieldTypeDivs = [];
        var fields = this.fields;
        for (var i = 0; i < fields.length; i++) {
            var fieldType/*:FieldType*/ = fields[i];
            fieldTypeDivs.push(fieldType.mkDiv());
        }
        //TODO: use partial templates
        var template = templateMgr.getTemplate("compositeVal");
        var retVal = template(jQuery.extend({ "fieldTypeDivs": fieldTypeDivs }, this));
        //var retVal = template(this);
        if (!retVal) throw new Error("template could not be applied");
        return retVal;
    }
}

export class FieldVal {
    __ps_cons;
    constructor(public fname/*:String*/, public ftype/*:String*/, public fval?/*:CompositeVal|PrimitiveVal*/) {
        this.__ps_cons = 'FieldVal';
    }
    mkDiv() {
        var fieldTypeObj = getType(this.ftype);
        var ftypeDiv = mkTypeDiv(fieldTypeObj)

        var template = templateMgr.getTemplate("fieldVal");
        var retVal = template(jQuery.extend({ "ftypeDiv": ftypeDiv }, this));
        if (!retVal) throw new Error("template could not be applied");
        return retVal;
    }
}


export var collectionValsList = ["List", "Tuple"];

//example: CollectionType(List, Array(<termTpe>))
//example: CollectionType(Tuple, Array(<tpe1>, <tpe2>))
export class ListVal {
    __ps_cons;
    constructor(public paramType, public items) {
        this.__ps_cons = 'ListVal';
    }
    mkDiv() {
        var dummyVal = getType(this.paramType);
        var paramDiv = mkTypeDiv(dummyVal);

        var template = templateMgr.getTemplate("listVal");
        var retVal = template({ "paramDiv": paramDiv });
        if (!retVal) throw new Error("template could not be applied");
        return retVal;
    }
}

export class TupleVal {
    __ps_cons;
    // paramTypes: array of types. ["Var", "Term"]
    // items: array of objects
    constructor(public paramTypes, public items) {
        this.__ps_cons = 'TupleVal';
    }
    mkDiv () {
        var itemContentDivs = _.map(this.paramTypes, function (paramType) {
            var dummyVal = getType(paramType);
            var itemContentDiv = mkTypeDiv(dummyVal);
            return itemContentDiv;
        });

        var template = templateMgr.getTemplate("tupleVal");
        var retVal = template({ "itemContentDivs": itemContentDivs });
        if (!retVal) throw new Error("template could not be applied");
        return retVal;
    }
}


//------------------------------------------------------------------------------------------------------------
//---- Type repositories ------------------------------------------------
//------------------------------------------------------------------------------------------------------------
export var absValDb = {};
absValDb["Tactic"] = new AbstractVal("Tactic", ["stepIntoUnknownProgIdx", "stepIntoUnknownProgId", "replaceFormula", "retValTactic",
                "rcvInPost", "rtvInPost", "deleteConjunct", "assumeAssignment", "assumeSkip", "stepOut",
                "assignmentDerivation", "guessExprValues", "applyHint", "stepOutAll", "initTactic"]);

////////////////////////////////////////////////////////////////////////////////			
export var primitiveValDb = {};
primitiveValDb["FOLFormula"] = new PrimitiveVal("FOLFormula");
primitiveValDb["Option[Term]"] = new PrimitiveVal("Option[Term]");
primitiveValDb["Var"] = new PrimitiveVal("Var");
primitiveValDb["Integer"] = new PrimitiveVal("Integer");
primitiveValDb["String"] = new PrimitiveVal("String");

////////////////////////////////////////////////////////////////////////////////

export var compositeValDb = {};
var compArr: any[][] = [
	            ["rootTactic", ["tactic", "Tactic"]],
	            ["stepIntoUnknownProgIdx", ["idx", "Integer"]],
	            ["stepIntoUnknownProgId", ["id", "Integer"]],
	            ["replaceFormula", ["newf", "FOLFormula"]],
	            ["retValTactic", ["initTerm", "Option[Term]"]],
	            ["rcvInPost", ["const0", "Var"], ["initValue0", "Term"], ["bounds", "FOLFormula"]],
	            ["rtvInPost", ["const0", "Term"], ["variable0", "Var"], ["initValue0", "Term"], ["bounds", "FOLFormula"]],
	            ["deleteConjunct", ["conjuct", "FOLFormula"], ["variant", "Term"]],
	            ["assumeAssignment", ["lhsRhsTuples", "List[(Var, Term)]"]],
	            ["assignmentDerivation", ["lhsVars", "List[Var]"]],
	            ["assumeSkip"],
	            ["stepOut"],
	            ["guessExprValues", ["primedVarTermList", "List[(Var, Term)]"]],
	            ["applyHint", ["antecedents", "List[FOLFormula]"], ["consequents", "List[FOLFormula]"]],
	            ["stepOutAll"],
                ["initTactic", ["name", "String"], ['params', "List[Var]"], ["retVar", "String"], ["retType", "String"], ["preF", "FOLFormula"], ["postF", "FOLFormula"]]
];

for (var i = 0; i < compArr.length; i++) {
    var typeName = compArr[i][0];
    var fieldVars = [];
    for (var j = 1; j < compArr[i].length; j++) {
        var fname = compArr[i][j][0];
        var ftype = compArr[i][j][1];
        fieldVars.push(new FieldVal(fname, ftype));
    }
    compositeValDb[typeName] = new CompositeVal(typeName, fieldVars);
}

export var getType = function (typeStr) {
    var retVal: any;
    if (typeStr in absValDb) {
        return absValDb[typeStr];
    }
    if (typeStr in compositeValDb) {
        return compositeValDb[typeStr];
    }

    if (typeStr in primitiveValDb) {
        return primitiveValDb[typeStr];
    }
    //Input Str : List[(Var, Term)]
    //Desired Type Obj: ListVal((Var, Term), [])
    var res = typeStr.match(/^List\[(.*)\]$/);
    if (res != undefined) {
        var paramType = res[1];
        retVal = new ListVal(paramType, []);
        //var retVal = new CollectionVal("List", [res[1]]);
        return retVal;
    }
    //Input Str : (Var, Term)
    //Desired Type Obj: TupleVal([Var", "Term"], [])				
    var res = typeStr.match(/^\((.*)\)$/);
    if (res != undefined) {
        var tpeArray = res[1].split(", ");
        retVal = new TupleVal(tpeArray, []);
        //var retVal = new CollectionVal("Tuple", tpeArray);
        return retVal;
    }

    throw new Error("typeStr " + typeStr + " is not recognized.");
}
////////////////////////////////////////////////////////////////////////
//*Given an object of */
export var mkTypeDiv = function (type) {
    var retVal = "";
    if (type.typeName in primitiveValDb) {
        retVal = type.mkDiv();
    } else if (type.typeName in absValDb) {
        //return mkAbsTypeDiv(type);
        retVal = type.mkDiv();
    } else if (type.typeName in compositeValDb) {
        retVal = type.mkDiv();
    } else if (type.__ps_cons === "ListVal" || type.__ps_cons === "TupleVal") {
        retVal = type.mkDiv();
    }
    if (!retVal) throw new Error("mkTypeDiv failed");
    return retVal;
};

////////////////////////////////////////////////////////////////////////////////	


