/// <reference path="typings/yui3/yui.d.ts" />
/// <reference path="typings/requirejs/require.d.ts" />
"use strict";
define(["require", "exports", "psweb.jquery.layout", "synthtree_model"], function(require, exports, pjl, stm) {
    pjl;
    stm;

    exports._dummyExport = undefined;

    $(document).ready(function () {
        function origin() {
            return window.location.protocol + "//" + window.location.host;
        }

        //Execute the derivation script and load the page
        function loadGalleryDeriv(derivName) {
            var loadGalleryDerivUrl = origin() + "/loadGalleryDeriv/" + derivName;
            $.ajax({
                url: loadGalleryDerivUrl,
                type: 'POST',
                contentType: 'application/json; charset=utf-8',
                data: JSON.stringify({}),
                dataType: 'json',
                success: function (newName) {
                    window.location.href = origin() + "/derivation/" + newName;
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                }
            });
        }

        function createGalleryPanel(Y, srcNode) {
            var panel = new Y.Panel({
                srcNode: srcNode,
                headerContent: 'Derivation Gallery',
                width: 400,
                zIndex: 10000,
                centered: true,
                modal: true,
                visible: false,
                render: true,
                plugins: [Y.Plugin.Drag]
            });
            panel.plug(Y.Plugin.Drag, { handles: ['.yui3-widget-hd'] });
            return panel;
        }

        function populateGalleryPanel(Y, galleryPanel) {
            var galleryDerivationsUrl = origin() + "/galleryDerivations";
            $.ajax({
                url: galleryDerivationsUrl,
                type: 'Get',
                dataType: 'json',
                success: function (derivationList) {
                    processDerivs(derivationList);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                }
            });

            function processDerivs(derivs) {
                //populate galleryPanel
                var i = 0;
                var containerDiv = Y.Node.create('<div class=derivContainer></div>');
                for (i = 0; i < derivs.length; i++) {
                    var derivDiv = Y.Node.create('<div id=' + derivs[i] + '>' + derivs[i] + '</div>');
                    derivDiv.addClass("derivDiv");
                    derivDiv.addClass("FakeLink ");
                    containerDiv.append(derivDiv);
                }
                Y.one('#galleryPanel').append(containerDiv);

                //bind click events on derivation divs.
                var derivationDivs = Y.all('.derivDiv');
                derivationDivs.on('click', function (e) {
                    galleryPanel.hide();
                    var derivationName = e.target.get("id");
                    loadGalleryDeriv(derivationName);
                });
            }
        }

        function resetTree() {
            var derivName = window.location.pathname.replace(/^\/derivation\//, "");
            var resetTreeUrl = origin() + "/resetTree/" + derivName;
            $.ajax({
                url: resetTreeUrl,
                type: 'POST',
                contentType: 'application/json; charset=utf-8',
                data: JSON.stringify({}),
                dataType: 'html',
                success: function () {
                    window.location.reload(true);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                }
            });
        }

        function isDerivNameValid(derivName) {
            return derivName.length <= 254 && derivName.match(/^[A-Za-z0-9_-]+$/) !== null;
        }

        function newDerivation() {
            var derivName = prompt("Enter derivation name", "");
            var isValid = isDerivNameValid(derivName);
            if (isValid) {
                var newDerivationUrl = origin() + "/newDerivation/" + derivName;
                var redirectUrl = origin() + "/derivation/" + derivName;
                console.log("newDerivation starting ...");
                $.ajax({
                    url: newDerivationUrl,
                    type: 'POST',
                    contentType: 'application/json; charset=utf-8',
                    data: JSON.stringify({}),
                    dataType: 'html',
                    success: function () {
                        console.log("newDerivation request successful");
                        window.location.href = redirectUrl;
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log("newDerivation failed");
                        console.log(textStatus, errorThrown);
                    }
                });
            } else {
                alert("Invalid derivation name. \nShould match [A-Za-z0-9_-]+ and should be shorter than 254 characters.");
            }
        }

        function logout() {
            var logoutUrl = origin() + "/logout";

            $.ajax({
                url: logoutUrl,
                type: 'POST',
                contentType: 'application/json; charset=utf-8',
                data: JSON.stringify({}),
                dataType: 'html',
                success: function () {
                    console.log("logout successful");

                    //window.location.reload(true);
                    login();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                }
            });
        }

        function login() {
            //window.open('login', '_self', false)
            window.location.href = 'login';
        }

        function toggleLog(errorContainerLayout) {
            console.log("state: " + errorContainerLayout.state.south.isHidden);
            if (errorContainerLayout.state.south.isHidden) {
                console.log("is hidden...showing now...");
                errorContainerLayout.show("south");
                errorContainerLayout.open("south");
                //TODO: update log
            } else {
                console.log("hiding");
                errorContainerLayout.hide("south");
            }
        }

        function notImplementedError() {
            alert('This functionality is not implemented.');
        }

        function setAsCurNode() {
            var selNodeId = stm.gPSState.getSelNodeId();
            stm.gPSState.setCurNodeId(selNodeId);
        }

        function delCurNode() {
            var selNodeId = stm.gPSState.getCurNodeId();
            //stm.gPSState.delCurNodeId(selNodeId);
        }

        function loadLocalFile() {
            window.location.href = origin() + '/uploadForm';
        }

        function downloadDerivation() {
            var pathName = window.location.pathname;
            if (pathName.match(/^\/derivation\//) !== null) {
                var derivName = pathName.replace(/^\/derivation\//, "");
                window.location.href = origin() + '/downloadDerivation/' + derivName;
            } else {
                alert("unable to download");
            }
        }

        // Call the "use" method, passing in "node-menunav".  This will load the
        // script and CSS for the MenuNav Node Plugin and all of the required
        // dependencies.
        YUI().use('node-menunav', 'panel', 'dd-plugin', function (Y) {
            // Retrieve the Node instance representing the root menu
            // (<div id="productsandservices">) and call the "plug" method
            // passing in a reference to the MenuNav Node Plugin.
            var menu = Y.one("#psMenuBar");
            menu.plug(Y.Plugin.NodeMenuNav, {
                submenuShowDelay: 0
            });

            // Show the menu now that it is ready
            //menu.get("ownerDocument").get("documentElement").removeClass("yui3-loading");
            menu.removeClass("yui3-loading");
            var errorContainerLayout = pjl.dolayout();

            var galleryPanel = createGalleryPanel(Y, '#galleryPanel');

            //Bind galleryMenu to show galleryPanel
            var galleryMenu = Y.one('#galleryMenu');
            galleryMenu.on('click', function (e) {
                galleryPanel.show();
            });

            populateGalleryPanel(Y, galleryPanel);

            //Bind newMenu
            var newMenu = Y.one('#newMenu');
            newMenu.on('click', function (e) {
                newDerivation();
            });

            //Bind resetMenu
            var resetMenu = Y.one('#resetMenu');
            resetMenu.on('click', function (e) {
                resetTree();
            });

            //Bind loadLocalMenu
            var loadLocalMenu = Y.one('#loadLocalMenu');
            loadLocalMenu.on('click', function (e) {
                loadLocalFile();
            });

            //Bind downloadDerivationMenu
            var downloadDerivationMenu = Y.one('#downloadDerivationMenu');
            downloadDerivationMenu.on('click', function (e) {
                downloadDerivation();
            });

            //Bind logoutMenu
            var logoutMenu = Y.one('#logoutMenu');
            logoutMenu.on('click', function (e) {
                logout();
            });

            //Bind show log
            var toggleLogMenu = Y.one('#toggleLogMenu');
            toggleLogMenu.on('click', function (e) {
                toggleLog(errorContainerLayout);
            });

            //Bind preferences menu
            var preferencesMenu = Y.one('#preferencesMenu');
            preferencesMenu.on('click', function (e) {
                notImplementedError();
            });

            //Bind select current node menu
            var setAsCurNodeMenu = Y.one('#setAsCurNodeMenu');
            setAsCurNodeMenu.on('click', function (e) {
                setAsCurNode();
            });

            //Bind delete node menu
            var delCurNodeMenu = Y.one('#delCurNodeMenu');
            delCurNodeMenu.on('click', function (e) {
                delCurNode();
            });
        });
    });
});
//# sourceMappingURL=psMenuBar.js.map
