/// <reference path="typings/underscore/underscore.d.ts" />
/// <reference path="typings/backbone/backbone.d.ts" />
/// <reference path="typings/toastr/toastr.d.ts" />
/// <reference path="typings/jqueryui/jqueryui.d.ts" />
/// <reference path="typings/jquery/jquery.d.ts" />
/// <reference path="typings/requirejs/require.d.ts" />
/// <reference path="typings/log4javascript/log4javascript.d.ts" />
/// <amd-dependency path="ps_jquery_utils" />
/// <amd-dependency path="psweb.jquery.layout" />
// <amd-dependency path="input_panel2" />
"use strict";
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
define(["require", "exports", "options_handler", "toggleId", "foldableDiv", "input_panel2", "synthtree_model", "templateMgr", "minimizableDiv", "minimizableWithTitle", "psMenuBar", "ps_jquery_utils", "psweb.jquery.layout"], function(require, exports, oh, tid, fdm, ip2, stm, templateMgr, mdm, mwt, pmb) {
    oh;
    tid;
    fdm;
    ip2;

    stm;
    templateMgr;
    mdm;
    mwt;
    pmb;

    var toastr = require('toastr');
    var log4javascript = require('log4javascript');

    //---------------------------------------------------------
    //toastr.info("In ps derivation...");
    var AppView = (function (_super) {
        __extends(AppView, _super);
        function AppView(psState, options) {
            _super.call(this, options);
            this.psState = psState;
            /**/ this.logger = log4javascript.getLogger("webapp.AppView");
            /**/ this.logger.trace("BeginSection(AppView.constructor)");
            this.tacticsPanelView = new TacticsPanelView(psState);
            this.tacticsPanelView.setElement(this.$('.left'));

            //this.tacticsPanelView.render();
            this.contentView = new ContentView(psState);
            this.contentView.setElement(this.$('.content'));
            this.inputPanelView = new ip2.InputPanelView(psState);
            this.inputPanelView.setElement(this.$('.inputPanel'));
            this.inputPanelView.render();
            this.keyBinder = new KeyBinder(psState, { el: 'body' });
            $('body .mathquill-editable').mathquill('editable');
            /**/ this.logger.trace("EndSection(AppView Constructor)");
        }
        AppView.prototype.start = function () {
            /**/ this.logger.trace("BeginSection(AppView.start)");
            stm.gPSState.getStateFromServer();
            /**/ this.logger.trace("EndSection(AppView.start)");
        };
        AppView.prototype.render = function () {
            return this;
        };
        return AppView;
    })(Backbone.View);

    var TacticsPanelView = (function (_super) {
        __extends(TacticsPanelView, _super);
        function TacticsPanelView(psState, options) {
            _super.call(this, options);
            this.psState = psState;
            /**/ this.logger = log4javascript.getLogger("webapp.TacticsPanelView");
            /**/ this.logger.trace("BeginSection(TacticsPanelView.constructor)");
            this.events = {};
            this.path = [];
            this.nsViews = [];
            this.listenTo(psState, 'model:stateChanged', $.proxy(this.onStateChanged, this));
            /**/ this.logger.trace("TacticsPanelView now listening to model:stateChanged");
            this.listenTo(psState, 'model:nodeAdded', $.proxy(this.onNodeAdded, this));
            /**/ this.logger.trace("TacticsPanelView now listening to model:nodeAdded");
            this.listenTo(psState, 'model:selectedNodeChanged', $.proxy(this.onSelectedNodeChanged, this));
            /**/ this.logger.trace("TacticsPanelView now listening to model:selectedNodeChanged");
            /**/ this.logger.trace("EndSection(TacticsPanelView.constructor)");
        }
        TacticsPanelView.prototype.onStateChanged = function () {
            var _this = this;
            /**/ this.logger.trace("BeginSection(TacticsPanelView.onStateChanged)");
            this.cleanup();

            //Update path
            /**/ this.logger.trace("getting path of the selected node ...");
            this.path = this.psState.getPathOfSelNode();

            //Update nsViews
            /**/ this.logger.trace("updating node sibling view of nodes in the path...");
            _.each(this.path, function (synthNode) {
                _this.nsViews.push(new NodeSiblingsView(synthNode, _this.psState));
            });

            //Update $el
            /**/ this.logger.trace("rendering the tacticsPanelView");
            this.render();
            /**/ this.logger.trace("EndSection(TacticsPanelView.onStateChanged)");
        };

        TacticsPanelView.prototype.cleanup = function () {
            /**/ this.logger.trace("TacticsPanelView.cleanup: cleaning up the tacticspanel view");
            this.path = [];
            this.nsViews = []; //TODO: clear the nsViews elements
            this.$el.empty();
        };

        TacticsPanelView.prototype.onNodeAdded = function () {
        };

        TacticsPanelView.prototype.render = function () {
            var _this = this;
            /**/ this.logger.trace("BeginSection(TacticsPanelView.render)");
            _.each(this.nsViews, function (nsView) {
                nsView.setElement($('<div></div>'));
                _this.$el.append(nsView.render().el);
            });
            /**/ this.logger.trace("EndSection(TacticsPanelView.render)");
            return this;
        };

        TacticsPanelView.prototype.onSelectedNodeChanged = function () {
            /**/ this.logger.trace("BeginSection(TacticsPanelView.onSelectedNodeChanged)");
            var selNode = this.psState.getSelNode();
            if (_.contains(this.path, selNode)) {
                //Do nothing
            } else {
                this.onStateChanged();
            }
            /**/ this.logger.trace("EndSection(TacticsPanelView.onSelectedNodeChanged)");
        };
        return TacticsPanelView;
    })(Backbone.View);

    var SiblingView = (function (_super) {
        __extends(SiblingView, _super);
        function SiblingView(node, psState, options) {
            _super.call(this, options);
            this.node = node;
            this.psState = psState;
            /**/ this.logger = log4javascript.getLogger("webapp.SiblingView");
            this.events = {
                'click div.siblingitem': 'onClick'
            };
        }
        SiblingView.prototype.render = function () {
            /**/ this.logger.trace("rendering SiblingView...");
            var template = templateMgr.getTemplate("siblingsView");
            this.$el.append(template());

            //this.$el.append('<div class="siblingitem">O</div>');
            return this;
        };
        SiblingView.prototype.onClick = function () {
            /**/ this.logger.trace("SiblingView.onClick. Update selected node");
            console.log("sibling node clicked");
            this.psState.setSelNodeId(this.node.getNodeId());
        };
        return SiblingView;
    })(Backbone.View);

    var NodeSiblingsView = (function (_super) {
        __extends(NodeSiblingsView, _super);
        /*
        Constructor takes a "node" and "psState" as input. It then extracts the left and right sibling nodes
        of the current node adnd creates the sibling views.
        */
        function NodeSiblingsView(node, psState, options) {
            _super.call(this, options);
            this.node = node;
            this.psState = psState;
            /**/ this.logger = log4javascript.getLogger("webapp.NodeSiblingsView");
            /**/ this.logger.trace("BeginSection(NodeSiblingsView.constructor)");
            /**/ this.logger.trace("populating left right siblings and views...");
            this.populateLeftRightSiblingsAndViews();
            /**/ this.logger.trace("registered handlers for click .nodeview and click .menuicon");
            this.events = {
                "click .nodeview": "onClick",
                "click .menuicon": "onMenuIcon"
            };
            /**/ this.logger.trace("listening to model:selectedNodeChanged and model:currentNodeChanged");
            this.listenTo(psState, 'model:selectedNodeChanged', $.proxy(this.renderSelectedNode, this));
            this.listenTo(psState, 'model:currentNodeChanged', $.proxy(this.renderCurrentNode, this));
            /**/ this.logger.trace("EndSection(NodeSiblingsView.constructor)");
        }
        NodeSiblingsView.prototype.populateLeftRightSiblingsAndViews = function () {
            var _this = this;
            /**/ this.logger.trace("BeginSection(NodeSiblingsView.populateLeftRightSiblingsAndViews)");
            var leftRightSiblings = this.psState.getLeftRightSiblings(this.node);
            this.leftSiblings = leftRightSiblings[0];
            this.rightSiblings = leftRightSiblings[1];
            this.leftViews = [];
            _.each(this.leftSiblings, function (ls) {
                _this.leftViews.push(new SiblingView(ls, _this.psState));
            });
            this.rightViews = [];
            _.each(this.rightSiblings, function (rs) {
                _this.rightViews.push(new SiblingView(rs, _this.psState));
            });
            /**/ this.logger.trace("EndSection(NodeSiblingsView.populateLeftRightSiblingsAndViews)");
        };

        //RefactorTask: Use templates
        /*
        */
        NodeSiblingsView.prototype.render = function () {
            /**/ this.logger.trace("BeginSection(NodeSiblingsView.render)");
            this.$el.addClass('nsview'); //TODO: avoid adding class to $el.

            var leftSiblingsDiv = $("<div class='siblingsview'></div>");
            _.each(this.leftViews, function (lview) {
                lview.setElement($('<div></div>'));
                leftSiblingsDiv.append(lview.render().el);
            });
            this.$el.append(leftSiblingsDiv);

            this.$el.append('<div class="nodeview">' + this.node.getNodeId() + this.node.getTactic().tacticName + '</div>');

            var rightSiblingsDiv = $("<div class='siblingsview'></div>");
            _.each(this.rightViews, function (rview) {
                rview.setElement($('<div></div>'));
                rightSiblingsDiv.append(rview.render().el);
            });

            this.$el.append(rightSiblingsDiv);

            //var contextMenuDiv = $("<div><ul id='nodeContextMenu'><li>menu1</li><li>menu2</li></ul></div>");
            //contextMenuDiv.children("#nodeContextMenu").menu();
            var menuIconDiv = $('<div class="menuicon"><img src="/assets/images/nodeOptions.png" alt="xxx"> </div>');

            //menuIconDiv.append(contextMenuDiv);
            this.$el.append(menuIconDiv);

            this.renderSelectedNode();
            this.renderCurrentNode();
            /**/ this.logger.trace("EndSection(NodeSiblingsView.render)");
            return this;
        };

        NodeSiblingsView.prototype.renderSelectedNode = function () {
            if (this.psState.getSelNodeId() === this.node.getNodeId()) {
                this.$el.children('.nodeview').addClass('selected');
            } else {
                this.$el.children('.nodeview').removeClass('selected');
            }
        };

        NodeSiblingsView.prototype.renderCurrentNode = function () {
            if (this.psState.getCurNodeId() === this.node.getNodeId()) {
                this.$el.addClass('current');
            } else {
                this.$el.removeClass('current');
            }
        };

        NodeSiblingsView.prototype.onClick = function () {
            console.log("onClick called");
            /**/ this.logger.trace("NodeSiblingsView.onclick called. Updating selected node.");

            //console.log("Event: NodeSiblingsView.event['click *'] = this.onClick");
            this.psState.setSelNodeId(this.node.getNodeId());
        };

        NodeSiblingsView.prototype.onMenuIcon = function () {
            console.log("on menu icon clicked");
            /**/ this.logger.trace("NodeSiblingsView.onMenuIcon called.");
            this.setSelAndCurNode();
        };

        NodeSiblingsView.prototype.setSelAndCurNode = function () {
            var srcNode = this.node.getNodeId();
            this.psState.setSelNodeId(srcNode);
            this.psState.setCurNodeId(srcNode);
        };
        return NodeSiblingsView;
    })(Backbone.View);

    //
    var ContentView = (function (_super) {
        __extends(ContentView, _super);
        function ContentView(psState, options) {
            _super.call(this, options);
            this.psState = psState;
            /**/ this.logger = log4javascript.getLogger("webapp.ContentView");
            /**/ this.logger.trace("BeginSection(ContentView.constructor)");
            this.events = {};
            this.contextView = new ContextView(psState);
            _.bindAll(this, 'render');
            this.listenTo(this.psState, "model:stateChanged", this.render);
            this.listenTo(this.psState, "model:selectedNodeChanged", this.render);
            /**/ this.logger.trace("listening to model:stateChanged and model:selectedNodeChanged");
            /**/ this.logger.trace("EndSection(ContentView.constructor)");
        }
        ContentView.prototype.render = function () {
            /**/ this.logger.trace("rendering content view...");
            this.$el.empty();
            this.contextView.render();
            this.$el.append(this.contextView.$el);
            var sn = this.psState.getSelNodeObj();
            console.log("Logging sn");
            console.log($(sn));
            this.$el.append(sn.html()); //for some reason, css file hides the root node (.nodeObj)
            return this;
        };
        return ContentView;
    })(Backbone.View);

    ////
    var ContextView = (function (_super) {
        __extends(ContextView, _super);
        function ContextView(psState, options) {
            _super.call(this, options);
            /**/ this.logger = log4javascript.getLogger("webapp.ContextView");
            this.events = {};
            this.psState = psState;
        }
        ContextView.prototype.render = function () {
            /**/ this.logger.trace("rendering contextview...");
            this.$el.empty();
            var sn = this.psState.getSelNode();
            var ctx = sn.getContext().contextObj;
            this.$el.append(ctx.html());

            //this.$el.append("<div>CONTEXT</div>");
            console.log("ContextView");
            console.log(sn.getContext().contextObj);
            return this;
        };
        return ContextView;
    })(Backbone.View);

    var KeyBinder = (function (_super) {
        __extends(KeyBinder, _super);
        function KeyBinder(psState, options) {
            _super.call(this, options);
            this.psState = psState;
            //this.events = {
            //    'keydown ctrl+down': psState.selectNextNode,
            //    'keydown ctrl+up': psState.selectPrevNode
            //};
            //$(document).bind('keydown', 'ctrl+down', $.proxy(psState.selectNextNode, psState));
            //$(document).bind('keydown', 'ctrl+up', $.proxy(psState.selectPrevNode, psState));
            //toggle id keystroke is implemented in toggleId.ts
        }
        return KeyBinder;
    })(Backbone.View);

    $(document).ready(function () {
        //------------------
        // Logger Initialization
        var logger = log4javascript.getLogger("webapp");
        logger.setAdditivity(false);
        logger.setLevel(log4javascript.Level.TRACE);

        // PopUp appender
        var popUpAppender = new log4javascript.PopUpAppender();
        var popUpLayout = new log4javascript.PatternLayout("%d{HH:mm:ss} %-5p - %m%n");
        popUpAppender.setLayout(popUpLayout);

        //Enable the following to set appender threshold.
        //popUpAppender.setThreshold(log4javascript.Level.ERROR);
        logger.addAppender(popUpAppender);

        // Ajax appender
        var ajaxAppender = new log4javascript.AjaxAppender("logClientMsg");
        var jsonLayout = new log4javascript.JsonLayout;
        ajaxAppender.setLayout(jsonLayout);
        ajaxAppender.addHeader("Content-Type", "application/json");

        //Enable the following to set appender threshold.
        //ajaxAppender.setThreshold(log4javascript.Level.ERROR);
        //logger.addAppender(ajaxAppender);
        //------------------
        /**/ logger.trace("BeginSection(ps_derivation.ts document ready)");
        /**/ logger.trace("Initialized the webapp logger");
        var appView = new AppView(stm.gPSState, { el: 'body' });
        appView.start();
        /**/ logger.trace("EndSection(ps_derivation.ts document ready)");
    });
});
//# sourceMappingURL=ps_derivation.js.map
