/// <reference path="typings/jquery/jquery.d.ts" />
/// <amd-dependency path="jquery" />
"use strict";
define(["require", "exports", "jquery"], function(require, exports) {
    //format("i can speak {language} since i was {age}",{language:'javascript',age:10});
    //format("i can speak {0} since i was {1}",'javascript',10});
    //To enter {, put {{
    function format(str, col) {
        col = typeof col === 'object' ? col : Array.prototype.slice.call(arguments, 1);

        return str.replace(/\{\{|\}\}|\{(\w+)\}/g, function (m, n) {
            if (m == "{{") {
                return "{";
            }
            if (m == "}}") {
                return "}";
            }
            return col[n];
        });
    }
    exports.format = format;
    ;

    //closest descendant
    //http://stackoverflow.com/questions/8961770/similar-to-jquery-closest-but-traversing-descedents
    (function ($) {
        $.fn.closest_descendent = function (filter) {
            var $found = $(), $currentSet = this;
            while ($currentSet.length) {
                $found = $currentSet.filter(filter);
                if ($found.length)
                    break;

                // Get all children of the current set
                $currentSet = $currentSet.children();
            }
            return $found.first();
        };
    })(jQuery);

    $.fn.exists = function () {
        return this.length !== 0;
    };
});
//# sourceMappingURL=ps_jquery_utils.js.map
