/// <reference path="typings/underscore/underscore.d.ts" />
/// <reference path="typings/backbone/backbone.d.ts" />
/// <reference path="typings/jquery/jquery.d.ts" />
/// <reference path="typings/requirejs/require.d.ts" />
/// <reference path="typings/log4javascript/log4javascript.d.ts" />
"use strict";
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
define(["require", "exports"], function(require, exports) {
    var log4javascript = require('log4javascript');
    /**/ var smlogger = log4javascript.getLogger("webapp.synthtree_models");

    //TODO: move to utils
    function origin() {
        return window.location.protocol + "//" + window.location.host;
    }

    var BackboneEventsImpl = (function () {
        function BackboneEventsImpl() {
            _.extend(this, Backbone.Events);
        }
        return BackboneEventsImpl;
    })();
    exports.BackboneEventsImpl = BackboneEventsImpl;

    var NodeMapExtractor;
    (function (NodeMapExtractor) {
        var idNodeMap = {};
        /**/ var logger = log4javascript.getLogger("webapp.NodeMapExtractor");

        function extractIdNodeMap($data) {
            /**/ logger.trace("in NodeMapExtractor->extractIdNodeMap");
            var $rootNode = $data.closest_descendent('.node');
            var rootNodeModel = processNode($rootNode, null, idNodeMap);
            return idNodeMap;
        }
        NodeMapExtractor.extractIdNodeMap = extractIdNodeMap;

        function processNode($node, parent, nodeMapParam) {
            /**/ logger.trace("in NodeMapExtractor->processNode");

            //step1 : create the node model (without childs)
            var nodeModel = createNodeModel($node, parent);

            //step2 : create the child nodes (with parent set properly)
            var childNodes = $node.children('.node');
            var childNodeModels = _.map(childNodes, function (child) {
                var $child = $(child);
                var childNodeModel = processNode($child, nodeModel, nodeMapParam);
                return childNodeModel;
            });

            //step3: set the childs
            nodeModel._childs = childNodeModels;

            //step4: add to map
            nodeMapParam[nodeModel.getNodeId()] = nodeModel;

            //srep5: return the model
            return nodeModel;
        }
        NodeMapExtractor.processNode = processNode;

        function createNodeModel($node, parent) {
            /**/ logger.trace("in NodeMapExtractor->createNodeModel");
            var nodeId = parseInt($node.children('.nodeid').text().trim());
            var nodeObj = $node.children('.nodeObj');
            var tacticName = $node.children('.tactic').text();
            var contextObj = $node.children('.contextObj');
            var contextModel = new ContextModel(contextObj);
            var tactic = new TacticModel(tacticName);
            var retVal = new SynthNodeModel(nodeId, nodeObj, tactic, contextModel, parent, []);
            return retVal;
        }
        NodeMapExtractor.createNodeModel = createNodeModel;
    })(NodeMapExtractor || (NodeMapExtractor = {}));

    //class PSStateData {
    //    synthTree: any;
    //    selNodeId: number;
    //    curNodeId: number;
    //    idNodeMap: {};
    //    constructor() {
    //    }
    //    init(tree, curNode: number, selNode: number, idNodeMap: Object) {
    //        this.synthTree = tree;
    //        this.curNodeId = curNode;
    //        this.selNodeId = selNode;
    //        this.idNodeMap = idNodeMap;
    //    }
    //}
    var PSStateJQueryUtils;
    (function (PSStateJQueryUtils) {
        /**/ var logger = log4javascript.getLogger("webapp.PSStateJQueryUtils");

        function getNodeId(node) {
            return parseInt($.trim(node.children(".nodeid").first().text()));
        }
        PSStateJQueryUtils.getNodeId = getNodeId;

        function getNodeElem(tree, nodeId) {
            var $nodeElem = tree.find('.node').filter(function () {
                var $nodeIdElem = $(this).children('.nodeid').first();
                var iNodeId = parseInt($nodeIdElem.text().trim());
                return iNodeId === nodeId;
            });
            console.assert($nodeElem.length > 0);
            return $nodeElem;
        }
        PSStateJQueryUtils.getNodeElem = getNodeElem;
    })(PSStateJQueryUtils || (PSStateJQueryUtils = {}));

    var PSState = (function (_super) {
        __extends(PSState, _super);
        function PSState() {
            _super.call(this);
            /**/ this.logger = log4javascript.getLogger("webapp.PSState");
            /**/ this.logger.trace("BeginSection(PSState.constructor)");
            this._idNodeMap = {};

            //_.extend(this, Backbone.Events);
            _.bindAll(this, 'getStateFromServerHandler');
            /**/ this.logger.trace("EndSection(PSState.constructor)");
        }
        //------------------------------------------
        //Setters
        PSState.prototype.init = function (tree, curNode, selNode, idNodeMap) {
            /**/ this.logger.trace("BeginSection(PSState.init)");
            this._synthTree = tree;
            this._curNodeId = curNode;
            this._selNodeId = selNode;
            this._idNodeMap = idNodeMap;
            this.trigger("model:stateChanged");
            /**/ this.logger.trace("EndSection(PSState.init)");
        };

        PSState.prototype.setSelNodeId = function (nodeId) {
            console.assert(this._idNodeMap[nodeId] !== undefined);
            if (this._selNodeId !== nodeId) {
                this._selNodeId = nodeId;
                this.trigger("model:selectedNodeChanged");
            }
        };

        PSState.prototype.setCurNodeId = function (nodeId) {
            console.assert(this._idNodeMap[nodeId] !== undefined);
            if (this._curNodeId !== nodeId) {
                this._curNodeId = nodeId;

                //Do not sync with server.
                //Any future request to server should sync the current node.
                //Edit: Syncing with applytactic will complicate things.
                this.setCurrentNodeOnServer(nodeId);
            }
        };

        PSState.prototype.addNode = function ($nodeDiv) {
            /**/ this.logger.trace("addNode");
            var newNodeId = PSStateJQueryUtils.getNodeId($nodeDiv);
            var curNodeId = this.getCurNodeId();

            if (curNodeId != newNodeId) {
                var curNode = this.getNodeElem(curNodeId);

                //add new node div to current node.
                curNode.append($nodeDiv);

                //Add the new node to the map
                var newNodeModel = NodeMapExtractor.createNodeModel($nodeDiv, this.getCurNode());
                this._idNodeMap[newNodeId] = newNodeModel;

                //fix the branching issue
                //register newNodeModel as child of the current Node
                this.getCurNode()._childs.push(newNodeModel);

                //update the selected node and the current node
                this.setCurNodeId(newNodeId);
                this.setSelNodeId(newNodeId);
                this.trigger("model:nodeAdded");
            }
        };

        //xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        //-------------------------------------------
        //Getters
        PSState.prototype.getSynthTree = function () {
            return this._synthTree;
        };
        PSState.prototype.getSelNodeId = function () {
            return this._selNodeId;
        };
        PSState.prototype.getCurNodeId = function () {
            return this._curNodeId;
        };
        PSState.prototype.getSynthNode = function (nodeId) {
            return this._idNodeMap[nodeId];
        };

        PSState.prototype.getNodeElem = function (nodeId) {
            return PSStateJQueryUtils.getNodeElem($(this.getSynthTree()), nodeId);
        };

        PSState.prototype.getSelNodeJQ = function () {
            return this.getNodeElem(this.getSelNodeId());
        };

        PSState.prototype.getSelNode = function () {
            return this.getSynthNode(this.getSelNodeId());
        };

        PSState.prototype.getCurNode = function () {
            return this.getSynthNode(this.getCurNodeId());
        };

        PSState.prototype.getSelNodeObj = function () {
            return this.getSelNode().getNodeObj();
        };

        PSState.prototype.getCurNodeObj = function () {
            return this.getCurNode().getNodeObj();
        };

        //xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        PSState.prototype.getStateFromServer = function () {
            var offline = false;
            if (!offline) {
                /**/ this.logger.trace("Registering getStateFromServerHandler to process state information...");
                /**/ this.logger.trace("Getting state from the server...");
                var pathname = window.location.pathname;
                var url = pathname.replace(/^\/derivation\//, "/getState/");
                $.ajax({
                    dataType: 'html',
                    url: url,
                    type: 'GET',
                    success: this.getStateFromServerHandler
                });
            } else {
                this.getStateFromStoredElement();
            }
        };

        PSState.prototype.getStateFromServerHandler = function (data) {
            console.log("data retrieved from server");
            /**/ this.logger.trace("State information received from the server...");

            // Enable when you want to generate file from which you want to generate the offline file.
            //set to "false" in offline and production mode.
            var generateOfflineMode = true;
            if (generateOfflineMode) {
                /* Store data to facilitate generation of offline html files */
                var $container = $('<div/>').html("<div class=ServerData></div>").contents();
                var $serverData = $container.append($(data));
                $('body').append($serverData);
            }

            var $data = $(data);
            var curNodeId = parseInt($data.children('.curNodeId').text().trim());

            //Remove the curNodeId div from the synthTree since we have already stored it in this.curNodeId
            $data.children('.curNodeId').remove();
            var synthTree = $data;
            var selNodeId = curNodeId;

            //var idNodeMap = this.extractIdNodeMap($data);
            var idNodeMap = NodeMapExtractor.extractIdNodeMap($data);
            this.init(synthTree, curNodeId, selNodeId, idNodeMap);
        };

        /*Useful in offline html files. Call from getStateFromServer() */
        PSState.prototype.getStateFromStoredElement = function () {
            //var data = $('body').data('ServerData');
            var data = $('body .ServerData').children(":first");
            this.getStateFromServerHandler(data);
        };

        //------------------------------------------------------
        PSState.prototype.applyTactic = function (inputData, derivName) {
            var _this = this;
            var data = JSON.stringify(inputData);
            /**/ console.log("sending request to server. data:");
            /**/ this.logger.trace("Sending request to server...");
            /**/ console.log(data);
            var applyTacticUrl = origin() + "/applyTactic/" + derivName;
            $.ajax({
                url: applyTacticUrl,
                type: 'POST',
                data: data,
                contentType: 'application/json; charset=utf-8',
                dataType: 'html',
                success: function (nodeDiv) {
                    var $nodeDiv = $(nodeDiv);
                    _this.addNode($nodeDiv);
                },
                error: function (errorDiv) {
                    console.log("applytactic error");
                    console.log($(".ApplyTacticError"));
                    $(".ApplyTacticError").html("<div>" + errorDiv.responseText + "</div>");
                }
            });

            return false;
        };

        PSState.prototype.setCurrentNodeOnServer = function (curNodeId) {
            var _this = this;
            /**/ this.logger.trace("Set Current Node On Server");
            var derivName = window.location.pathname.replace(/^\/derivation\//, "");
            var setCurNodeUrl = origin() + "/setCurNode/" + derivName;
            var data = { 'value': curNodeId };
            console.log(data);
            $.ajax({
                url: setCurNodeUrl,
                type: 'POST',
                data: JSON.stringify(data),
                contentType: 'application/json; charset=utf-8',
                dataType: 'html',
                success: function () {
                    /**/ _this.logger.trace("current Node request successfuly.");
                    _this.trigger("model:currentNodeChanged");
                },
                error: function () {
                    /**/ _this.logger.trace("current Node request Failed.");
                }
            });
        };

        PSState.prototype.test = function () {
            console.log("test called");
        };

        //TODO: move these methods to view.
        //selectNextNode() {
        //    var $selectedNode = this.getSelNodeJQ();
        //    //find the next .node
        //    var $nextNode = $selectedNode.children('.node');
        //    //activate the next .node
        //    if ($nextNode.length > 0) {
        //        var nextNodeId = PSStateJQueryUtils.getNodeId($nextNode);
        //        this.setSelNodeId(nextNodeId);
        //    }
        //}
        //selectPrevNode() {
        //    //find the selected .node
        //    var $selectedNode = this.getSelNodeJQ();
        //    //find the prev .node
        //    var $prevNode = $selectedNode.parent('.node');
        //    //activate the prev .node
        //    if ($prevNode.length > 0) {
        //        var prevNodeId = PSStateJQueryUtils.getNodeId($prevNode);
        //        this.setSelNodeId(prevNodeId);
        //    }
        //}
        //Get rightmost path containing the given node
        PSState.prototype.getRightMostPath = function (node) {
            /**/ this.logger.trace("getRightMostPath");
            var iNode = node;
            var iChilds = iNode.getChilds();
            while (iChilds.length > 0) {
                iNode = iChilds[iChilds.length - 1];
                iChilds = iNode.getChilds();
            }
            var retVal = [];

            //RefactorTODO: abstract out this method.
            var jNode = iNode;
            while (jNode.getParent() !== null) {
                retVal.push(jNode);
                jNode = jNode.getParent();
            }
            retVal.push(jNode);

            //return nodeModels;
            return retVal.reverse();
        };

        //Utilities
        // Condition 1: The returned path must contain the selNode
        // Condition 2: If possible, the returned path should contain the curNode
        // Condition 3: If there are multiple paths satisfying condition1 and condition 2
        // select the rightmost path.
        PSState.prototype.getPathOfSelNode = function () {
            /**/ this.logger.trace("getPathOfSelNode");
            var selNode = this.getSelNode();
            var curNode = this.getCurNode();
            var curPath = this.getRightMostPath(curNode);
            if (_.contains(curPath, selNode))
                return curPath;
            else {
                return this.getRightMostPath(selNode);
            }
        };

        PSState.prototype.getLeftRightSiblings = function (node) {
            /**/ this.logger.trace("getLeftRightSiblings of node" + node._nodeId);
            var parentNode = node.getParent();
            var leftSiblings = [];
            var rightSiblings = [];
            if (parentNode !== null) {
                var childs = parentNode.getChilds();
                var nodeIndex = _.indexOf(childs, node);
                leftSiblings = _.take(childs, nodeIndex);
                rightSiblings = _.drop(childs, nodeIndex + 1);
            }
            return [leftSiblings, rightSiblings];
        };
        return PSState;
    })(BackboneEventsImpl);
    exports.PSState = PSState;

    var SynthNodeModel = (function (_super) {
        __extends(SynthNodeModel, _super);
        function SynthNodeModel(nodeId, nodeObj, tactic, context, parent, childs) {
            _super.call(this);
            /**/ this.logger = log4javascript.getLogger("webapp.SynthNodeModel");

            //_.extend(this, Backbone.Events);
            this._nodeId = nodeId;
            this._nodeObj = nodeObj;
            this._tactic = tactic;
            this._context = context;
            this._parent = parent;
            this._childs = childs;
        }
        SynthNodeModel.prototype.getNodeId = function () {
            return this._nodeId;
        };
        SynthNodeModel.prototype.getNodeObj = function () {
            return this._nodeObj;
        };
        SynthNodeModel.prototype.getTactic = function () {
            return this._tactic;
        };
        SynthNodeModel.prototype.getContext = function () {
            return this._context;
        };
        SynthNodeModel.prototype.getParent = function () {
            return this._parent;
        };
        SynthNodeModel.prototype.getChilds = function () {
            return this._childs;
        };
        return SynthNodeModel;
    })(BackboneEventsImpl);
    exports.SynthNodeModel = SynthNodeModel;

    var TacticModel = (function (_super) {
        __extends(TacticModel, _super);
        function TacticModel(tacticName) {
            _super.call(this);
            this.tacticName = tacticName;
        }
        return TacticModel;
    })(BackboneEventsImpl);
    exports.TacticModel = TacticModel;

    var ContextModel = (function (_super) {
        __extends(ContextModel, _super);
        function ContextModel(contextObj) {
            _super.call(this);
            this.contextObj = contextObj;
        }
        return ContextModel;
    })(BackboneEventsImpl);
    exports.ContextModel = ContextModel;

    exports.gPSState = new PSState();
    /**/ smlogger.trace("create gPSState: PSState");
});
//# sourceMappingURL=synthtree_model.js.map
