/// <reference path="typings/toastr/toastr.d.ts" />
/// <reference path="typings/jqueryui/jqueryui.d.ts" />
/// <reference path="typings/jquery/jquery.d.ts" />
/// <reference path="typings/requirejs/require.d.ts" />


"use strict";
export var _dummyExport = undefined;

$(document).ready(function () {

    function toggleDisplayId() {
        $(".content .displayId").toggle();

        $(".content").toggleClass('ProgramAnnDisplayIdClass DisplayIdClass');
        //Do not display formula display ids when the node is a program node.
        $(".content .Invariant").not(".content .ProgramAnn .Invariant").toggleClass('InvariantDisplayIdClass DisplayIdClass');

        $(".content .Pred").not(".content .ProgramAnn .Pred").toggleClass('PredDisplayIdClass DisplayIdClass');

        $(".content .Var").not(".content .ProgramAnn .Var").toggleClass('VarDisplayIdClass TermDisplayIdClass DisplayIdClass');
        $(".content .Const").not(".content .ProgramAnn .Const").toggleClass('ConstDisplayIdClass TermDisplayIdClass DisplayIdClass');
        $(".content .ArrSelect").not(".content .ProgramAnn .ArrSelect").toggleClass('ArrSelectDisplayIdClass TermDisplayIdClass DisplayIdClass');
        $(".content .ArrStore").not(".content .ProgramAnn .ArrStore").toggleClass('ArrStoreDisplayIdClass TermDisplayIdClass DisplayIdClass');
        $(".content .QTerm").not(".content .ProgramAnn .QTerm").toggleClass('QTermDisplayIdClass TermDisplayIdClass DisplayIdClass');
        $(".content .FnApp").not(".content .ProgramAnn .FnApp").toggleClass('FnAppDisplayIdClass TermDisplayIdClass DisplayIdClass');

        $(".content .True1").not(".content .ProgramAnn .True1").toggleClass('True1DisplayIdClass  FormulaDisplayIdClass DisplayIdClass');
        $(".content .False1").not(".content .ProgramAnn .False1").toggleClass('False1DisplayIdClass FormulaDisplayIdClass DisplayIdClass');
        $(".content .Not").not(".content .ProgramAnn .Not").toggleClass('NotDisplayIdClass FormulaDisplayIdClass DisplayIdClass');
        $(".content .And").not(".content .ProgramAnn .And").toggleClass('AndDisplayIdClass FormulaDisplayIdClass DisplayIdClass');
        $(".content .Or").not(".content .ProgramAnn .Or").toggleClass('OrDisplayIdClass FormulaDisplayIdClass DisplayIdClass');
        $(".content .Impl").not(".content .ProgramAnn .Impl").toggleClass('ImplDisplayIdClass FormulaDisplayIdClass DisplayIdClass');
        $(".content .Iff").not(".content .ProgramAnn .Iff").toggleClass('IffDisplayIdClass FormulaDisplayIdClass DisplayIdClass');
        $(".content .Forall").not(".content .ProgramAnn .Forall").toggleClass('ForallDisplayIdClass FormulaDisplayIdClass DisplayIdClass');
        $(".content .Exists").not(".content .ProgramAnn .Exists").toggleClass('ExistsDisplayIdClass FormulaDisplayIdClass DisplayIdClass');
        $(".content .Unknown").not(".content .ProgramAnn .Unknown").toggleClass('UnknownDisplayIdClass FormulaDisplayIdClass DisplayIdClass');

        $('.right .statusbar .displayIdDiv').html('');

    }
    function toggleDisplayIdAndGoToBottom() {
        toggleDisplayId();
        //Go to bottom of the div
        $('.right').scrollTop($('.right')[0].scrollHeight);
    }

    $("#toggleIdBtn.topButton").click(toggleDisplayIdAndGoToBottom);

    //Keyboard shortcut for displaying the id  and going to bottom of the page.
    $(document).bind('keydown', 'ctrl+F10', toggleDisplayIdAndGoToBottom);

    $(".content").on({
        mouseover: function (event) {
            var activeElem = $(event.target).closest('.DisplayIdClass');
            var activeElemId = activeElem.attr('displayIdAttr');
            //Add tool tip 
            activeElem.attr('title', "ID: " + activeElemId);
            //display the id in status bar
            $('.right .statusbar .displayIdDiv').html("ID: " + activeElemId);
            //hilight the border of the activeElem
            $(".content").find(".DisplayIdClass").removeClass('outline-element');
            activeElem.addClass('outline-element');
            //activeElem.css('border-width', '7px');
        }
    });
 
    //a utility to hide the debug elements.
    //For some reason can not call it directly from console, hence binding to Ctrl+F9   
    function toggleDbg() {
        console.log("toggleDbg called");
        if ((<any>toggleDbg).show == undefined) {
            (<any>toggleDbg).show = true;
        }
        else {
            (<any>toggleDbg).show = !(<any>toggleDbg).show;
        }
        
        if ((<any>toggleDbg).show == true) {
            $(".ProgramAnn .id").show();
            //$(".posummary").show(); //TODO: enable these lines
            //$(".nodeObjDbg").show();
            //$(".pa_proofobligs").show();
            //$(".top").show();
            $(".statusbar").show();
            
        } else {
            $(".ProgramAnn .id").hide();
            //$(".posummary").hide(); //TODO: enable these lines
            //$(".nodeObjDbg").hide();
            //$(".pa_proofobligs").hide();
            //$(".top").hide();
            $(".statusbar").hide();
        }
    }
    $(document).bind('keydown', 'ctrl+F9', toggleDbg); 
});

