#!/bin/bash

declare -a packages=(libglfw3 libglfw3-dev libglew-dev libglc-dev libsoil-dev libglm-dev libgamin0 xterm)

for i in "${packages[@]}"
do
   dpkg -s "$i" &> /dev/null

	if [ $? -ne 0 ]; then
		sudo apt-get install $i
	fi
done
#############################################################################################################

#Installing libpng library from source
wget http://archive.ubuntu.com/ubuntu/pool/main/libp/libpng/libpng_1.2.54.orig.tar.xz

tar xvf  libpng_1.2.54.orig.tar.xz 

cd libpng-1.2.54
./autogen.sh
./configure
make -j8 
sudo make install

cd -
############################################################################################################

#Installing codeblocks 
sudo apt-get remove codeblocks
sudo rm -dR /usr/local/share/codeblocks
sudo dpkg -i simpleblocks.deb
sudo dpkg -i wxwidgets.deb

sudo chmod /etc/ld.so.conf
grep -q -F '/usr/local/lib' /etc/ld.so.conf || echo '/usr/local/lib' >> /etc/ld.so.conf
sudo ldconfig
############################################################################################################

#Change the option file from codeblocks simplecpp compiler
sudo cp options_scpp.xml /usr/local/share/codeblocks/compilers/
############################################################################################################

#configure and compile simplecpp codebase using local gcc compiler
echo "Compiling simplecpp codebase"
tar -xf simplecpp.tar
sudo cp -r simplecpp /usr/local/
cd /usr/local/simplecpp/
bash /usr/local/simplecpp/configure.sh
############################################################################################################

cd -
echo "Codeblocks Installed Successfully, Enjoy Coding..."
echo "Bye!!!"

exit 0;



