#include "colors.inc"
#include "stones.inc"
#include "textures.inc"
#include "glass.inc"
#include "stars.inc"
#include "stones1.inc"
#include "stones2.inc"
#include "metals.inc"
#include "woods.inc"


/********************TURN ON IF U WANT RADIOSITY CALCULATIONS...TAKES MUCH TIME **************/


global_settings {                      //For very good results !!!!
        ambient_light rgb<1, 1, 1>
        assumed_gamma 1.5
        radiosity
          {
            pretrace_start 0.06
            pretrace_end 0.02
            count 150
            recursion_limit 3
            nearest_count 10
            error_bound 0.8
          }

}
/*
global_settings {                      //For very good results !!!!
	ambient_light rgb<1, 1, 1>  
	assumed_gamma 1.5
	radiosity
	  {
	    pretrace_start 0.05
	    pretrace_end 0.01
	    count 200
	    recursion_limit 4
	    nearest_count 10
	    error_bound 0.5
	  }
}
*/

global_settings {ambient_light rgb<1, 1, 1>}  ///GLOBAL AMBIENCE 


//Street Light Bulb


#declare LIGHTBULB = sphere{ <0,0,1>, 1
	                texture{
        	                pigment{color rgb<clock*1, clock*1, clock*1>}
                	        finish{
                        	        ambient .8
                                	diffuse .6
                	              }
		                }
	                rotate -90*x
        	        scale .05
}


//Bulb used for yellow light Pole in backgnd. 

#declare YELLOWBULB = sphere{ <0,0,1>, 1
	                texture{
        	                pigment{color rgb<clock*1, clock*1, 0>}
                	        finish{
				        specular 1
					roughness 0.0005
					brilliance 5
        	                      }
                		}
	                rotate -90*x
        	        scale .05
}

//Moon...quite obvious !! :-)

#declare MOON = sphere{ <0,0,1>, 1
			normal { wrinkles clock*0.7 scale clock*0.1 }
		        pigment{color White}
                        scale 500
			
}

//The sky plane

plane {
	z, 1150
	texture {Starfield1}
}


//Moon as a light source

light_source { <-400,500,1149> color rgb<1,1,1> fade_distance 200 fade_power 0.01 looks_like{MOON}}


//Location and eye of the camera

camera {
	location <0, 0, -30>
	look_at 0
}

light_source { <0,0,-30> color rgb<clock*1,clock*1,clock*1>}


//White road strips !!

#declare ROAD_STRIP = box {
				<-0.05,-0.499999,-0.75>, <0.05,-0.499999,0.75>
				pigment { color rgb 1 }
}

//Street Light Pole base texture

#declare POLE_BASE = texture{
                          pigment{Gray75 }
                          finish{
                            ambient .1
                            diffuse .4
                            reflection .25
                            specular 1
			    roughness 0.0005
                         }
}

//Street Light Pole texture

#declare POLE = texture{
                   pigment{Silver }
                   finish{
                      ambient .1
                      diffuse .4
                      reflection .15
                      specular 1
                      roughness 0.0005
                      metallic
                   }
}

//The road

merge {
object{
box{
	<-1,-0.5,-35>, <1,-0.5,1150>
	pigment { Gray25 }
	normal { wrinkles .7 scale .1 }
}
}
object{	ROAD_STRIP translate -29*z  normal { wrinkles .1 scale .1 }}
object{ ROAD_STRIP translate -26.8*z normal { wrinkles .1 scale .1 }}
object{ ROAD_STRIP translate -24*z }
object{ ROAD_STRIP translate -19.6*z }
object{ ROAD_STRIP translate -14*z }
object{ ROAD_STRIP translate -4*z }

}


//LAYERED TEXTURE FOR THE FOOTPATH

#declare BRICK_TEXTURE = // basic bricks
	texture {
                pigment {
                        Irregular_Bricks_Ptrn (0.2, 0.5, 0.25, 0.01)
                        color_map {
                                [0.01, rgb 0.7]
                                [0.01, rgb 0.5]
                                  }
                        }
                normal {
                        Irregular_Bricks_Ptrn (0.2, 1, 0.25, 0.01) 6
                       }
	       rotate 90*x
        }
// the stains
        texture {
                pigment { spotted
                          color_map {
                                [ 0.000 color rgb<0.65, .45, .35> ]
                                [ 0.734 color rgb<1.000, 1.000, 1.000, 1.000> ]
                                [ 1.000 color rgb<1.000, 1.000, 1.000> ]
                                    }
                        turbulence 0.500
                        frequency 1.500
                        }
                normal { wrinkles 100.0000 }
                }

	texture { // ... and some sooty black marks
                  pigment { bozo
                            color_map {
                                [0.0 color Black ]
                                [0.2 color rgbt <1, 1, 1, 1> ]
                                [0.8 color rgbf <0, 0, 0, .5> ]
                                [1.0 color rgbt <0, 0, 0, 1> ]
                                      }
                            scale 3
                        }
		  normal { wrinkles 1 scale .2 }
} // (end of sooty mark texture)




//Left-Footpath
box {
	<-400,-0.5,-35>, <-1,-0.4,1150>
	texture{BRICK_TEXTURE}
}



//Right-Footpath
box {
        <1,-0.5,-35>, <400,-0.4,1150>
        texture{BRICK_TEXTURE}
}






//Light-Pole

#declare LIGHT_POLE = union{

//Base-cylinder
cylinder{
	 <0,-0.5,0>,<0,-0.25,0> 0.125
	 texture{POLE_BASE}
}

//Main Pole - bottom
cylinder{
         <0,-0.25,0>,<0,0.3,0> 0.05
         texture{POLE}
}


//Main Pole - top
cylinder{
         <0,0.3,0>,<0,1.25,0> 0.035
	 texture{POLE}
}

//Top Sphere
sphere{
	<0,1.25,0> 0.045
	texture{POLE}
}

//Top Cylinder
cylinder{
	<-0.05,1.1,0>,<0.65,1.1,0> 0.025
	texture{POLE}
}


triangle{
	<0,1.1,0>,<0.3,1.1,0>,<0,0.98,0>
	texture{POLE}
}



//Light-cone
cone { 
	<0.62, 1.07, 0>, 0.025 // Center and radius of one end
	<0.62,0.92,0>, 0.15 // Center and radius of other end
	open
	texture{POLE}
}
}


//LIGHTPOLES

object{	LIGHT_POLE translate <-1.2,0.1,-28.1>}
object{	LIGHT_POLE translate <-1.2,0.1,-24.6>}
object{ LIGHT_POLE translate <-1.2,0.1,-20.1>}
object{ LIGHT_POLE translate <-1.2,0.1,-14.6>}
object{ LIGHT_POLE translate <-1.2,0.1,-6.1>}
object{ LIGHT_POLE translate <-1.2,0.1,0.6>}


//STREET BULBS

light_source { <-0.58, 0.97, -28.14>
        color rgb<clock*1,clock*1,clock*1>
        spotlight
        radius 30
        falloff 35
        tightness .02
        point_at <-0.3, -0.5, -28.34>
        looks_like { LIGHTBULB }
}




light_source { <-0.58, 0.97, -24.64>
        color rgb <clock*1,clock*1,clock*1>
        spotlight
        radius 30
        falloff 35
        tightness .02
        point_at <-0.3, -0.5, -24.64>
        looks_like { LIGHTBULB }
}


light_source { <-0.58, 0.97, -20.14>
        color rgb<clock*1,clock*1,clock*1>
        spotlight
        radius 35
        falloff 40
        tightness .02
        point_at <-0.3, -0.5, -20.14>
       looks_like { LIGHTBULB }
}

light_source { <-0.58, 0.97, -14.64>
        color rgb<clock*1,clock*1,clock*1>
        spotlight
        radius 35
        falloff 40
        tightness .02
        point_at <-0.3, -0.5, -14.64>
        looks_like { LIGHTBULB }
}

light_source { <-0.58, 0.97, -6.14>
        color rgb<clock*1,clock*1,clock*1>
        spotlight
        radius 35
        falloff 40
        tightness .02
        point_at <-0.3, -0.5, -6.14>
        looks_like { LIGHTBULB }
}

light_source { <-0.57, 1.04, 0.62>
        color rgb<clock*1,clock*1,clock*1>
        spotlight
        radius 35
        falloff 40
        tightness .02
        point_at <-0.3, -0.5, 0.66>
        looks_like { LIGHTBULB }
}


//SignBoard
#declare SIGN_BOARD = union{
cylinder{<0,-0.5,0.1>, <0,0.5,0.1>, .2  pigment{color rgb<0.5,0,0> } scale <.1,1,.00001>}
sphere{<0,0.5,0>, .25
	pigment{color rgb<0.65,0,0>}
	scale <1,1,.00001>
}

text { 
	ttf "timrom.ttf" "IIT" 0.0001, 0 
	pigment { color White } 
	finish { reflection .65 specular 1 } 
	scale 0.12
	translate <-0.08,.55,-0.001> 
}

text {
        ttf "timrom.ttf" "POWAI" 0.0001, 0
        pigment { color White }
        finish { reflection .65 specular 1 }
	scale 0.12
	translate <-0.2,.41,-0.001>
}
}



object{SIGN_BOARD translate <-1.2,0.1,-25.6> }

//////////////////////////////////////////////////////////

//YELLOW LIGHT POLE

#declare LIGHTPOLE_YELLOW = union{

union{
	cone {  <0, -0.4, 0.6>, 0.025  <0,-0.5,0.6>, 0.25 open }
	cylinder{  <0,-0.45,0.6>,<0,1.4,0.6> 0.05}
	cylinder{  <-0.2,1.3,0.6>,<0.2,1.3,0.6> 0.02}
	cylinder{  <0,1.3,0.4>,<0,1.3,0.8> 0.02}

	pigment{color rgb <0.1,0.1,0.1>}
        finish{
                specular 1
                roughness 0.0005
                reflection .35
                brilliance 5
              }
     }

	cone {  <0, 1.38, 0.6>, 0.09  <0,1.58,0.6>, 0.25 pigment{Col_Glass_Yellow}  finish{F_Glass10} }
	cone {  <0,1.58,0.6>, 0.25    <0, 1.7, 0.6>, 0.025  pigment{Col_Yellow_01}}

}


///////////////////////////////// Yellow Lights and Pole ///////////////////////////////////////////

object {LIGHTPOLE_YELLOW translate <-5,0.1,-19>}
object {LIGHTPOLE_YELLOW translate <-5,0.1,-25>}
object {LIGHTPOLE_YELLOW translate <-5,0.1,-11>}
object {LIGHTPOLE_YELLOW translate <-5,0.1,-5>}

//YELLOW LIGHT BULBS

light_source { <-5, 1.5, -18.4>
	color rgb<clock*0.6,clock*0.8,clock*0.196078>
	area_light <-5.3, 1.47,-18.4>, <-4.7,1.53,-18.4>, 1, 2
	adaptive 1
	jitter
	fade_distance 4
	fade_power 1.8
	looks_like { YELLOWBULB }
}


light_source { <-5, 1.5, -24.4>
        color rgb<clock*0.6,clock*0.8,clock*0.196078>
        area_light <-5.3, 1.47,-18.4>, <-4.7,1.53,-18.4>, 1, 2
	adaptive 1
	jitter
	fade_distance 4
        fade_power 1.8
	looks_like { YELLOWBULB }
}

light_source { <-5, 1.5, -10.4>
        color rgb<clock*0.6,clock*0.8,clock*0.196078>
        area_light <-5.3, 1.47,-18.4>, <-4.7,1.53,-18.4>, 1, 2
	adaptive 1
	jitter
	fade_distance 4
        fade_power 1.8
	looks_like { YELLOWBULB }
}

light_source { <-5, 1.5, -4.4>
        color rgb<clock*0.6,clock*0.8,clock*0.196078>   //Yellow Green
	area_light <-5.3, 1.47,-18.4>, <-4.7,1.53,-18.4>, 1, 2
	adaptive 1
	jitter
	fade_distance 4
        fade_power 1.8
        looks_like { YELLOWBULB }
}

///////////////////////////////////////////////////////////////FENCE ////////////////////////

//THE FENCE

#declare FENCE = prism {
			linear_sweep
			linear_spline
			0,
			0.1,
                        22,
                        <0,1>, <0.1,0.6>
                        <0.1,0.35>, <0.3,0.35>
                        <0.3,0.25>, <0.1,0.25>
                        <0.1,0>, <0.3,0>
                        <0.3,-0.1>, <0.1,-0.1>
                        <0.1,-0.45>, <-0.1,-0.45>
                        <-0.1,-0.1>, <-0.3,-0.1>
                        <-0.3,0>, <-0.1,0>
                        <-0.1,0.25>, <-0.3,0.25>
                        <-0.3,0.35>, <-0.1,0.35>
                        <-0.1,0.6>, <0,1>
                        rotate <0,90,90>
			pigment { color rgb <1, 1, 1> }
                        finish{specular 1 roughness 0.0005}
}


#declare p = -1.1;
#declare i=-31;
   #while (i<p)
	object {FENCE translate <-7,-0.1,i>}
   #declare i=i+0.6;
#end



///////////////////////////////////////////////////////////////////////////////////////

//HOUSE 1 STARTING FROM CAMERA LOCATION

#declare HOUSE1 =union{ 
		difference {
		box{
			-1,1 
			pigment{
				brick Gray15 VeryDarkBrown
				scale 0.05
				}
			normal { gradient y
				 turbulence .5 lambda 2
				 normal_map {
					    [0.4 dents 20 scale 0.2]
					    [0.6 agate turbulence 1]
					    [1.0 dents 20 scale 0.2]
					    }
			      }

		   }

		box{ <-1.0001,-0.33,-0.2>, <0,0.33,0.5> 
		     pigment{color Wheat}
				normal { 
					gradient y
	                                turbulence .5 lambda 2
	                                normal_map {
        	                                    [0.4 dents 2 scale 0.2]
                	                            [0.6 agate turbulence 1]
                        	                    [1.0 dents 2 scale 0.2]
                                	            }
                            	      }
	      	}
	texture{T_Glass1}
	}
	cone{ <-1,0.78,0.85>, 0.1 <-1,1,0.85>, .00001 open pigment{Col_Glass_Ruby}}

}

#declare REDBULB = union {
                sphere{ <0,0,1>, 1}
                texture{
                        pigment{color rgb<clock*1, clock*0, clock*0>}
                        finish{
                                ambient .8
                                diffuse .6
                              }
                }
                rotate -90*x
                scale .05
}


object {HOUSE1 translate<2.5,0.6,-28>}

//BULB INSIDE THE HOUSE

light_source{<1.6,0.6,-27.6> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 1.8} //Col_Yellow_01

//RED BULB OUTSIDE THE HOUSE
light_source{
		<1.5,1.4,-27.152> 
		color rgb<clock*1,clock*0,clock*0>
		spotlight
	        radius 20
	        falloff 25
	        tightness .2
	        point_at <1.5, 0, -27.152>
		looks_like{REDBULB}
}
light_source{
        <1.5,1.4,-27.152>
        color rgb<clock*1,clock*0,clock*0>
        area_light <1.5,1.39,-27.153>, <1.5,1.41,-27.151>, 1, 1
        adaptive 1
        jitter
        fade_distance 1
        fade_power 10
}


//*****************************************HOUSE--1 COMPLETE************************/


////WINDOW DECLARED FOR HOUSE 2


//window
#declare WINDOW2 = merge{
	box{<-1,0,-0.4>,<1,2,0.4> texture{T_Old_Glass}}
	box{
		<-1,0.93,-0.41>,<1,1.07,-0.39> 
		pigment{color rgb <0.1,0.1,0.1>}
		finish{F_MetalE}
	}
	box{
		<-0.07,0,-0.41>,<0.07,2,0.39> 
		pigment{color rgb <0.04,0.04,0.04>}
	        finish{F_MetalE}
	}
	scale <0.33,0.25,1>
	pigment{color Wheat}	
}



//DOOR FOR HOUSE 2


#declare DOOR2 = merge{
	box{<-0.5,-0.5,-0.08>,<0.5,1,0.05> texture{T_Wood22}}
	box{<-0.5,0.33,-0.12>,<0.5,0.47,-0.05> pigment{color rgb <0.2,0.06,0.06>}}
	box{<-0.07,-0.5,-0.12001>,<0.07,1,-0.05001>pigment{color rgb <0.2,0.06,0.06>}}
	torus{
		0.08,0.03
		rotate -90*x
		translate <0,0.4,-0.12005>
		finish{F_MetalE}
	}
	torus{
	        0.08,0.03
	        rotate -90*x
	        translate <0,0.3,-0.12006>
		finish{F_MetalE}
	}
	cone{ <0,1.2,-0.08>, 0.1 <0,1.42,-0.08>, .0001 open pigment{Col_Glass_Yellow}}
	scale <0.55,0.55,1>
}

//HOUSE 2

#declare HOUSE2 = merge{
	box{<-1,-0.5,-1>,<1,1.5,1> 
	}
	object{WINDOW2 translate <-0.56,0.5,-0.601> pigment{color Wheat}}
	object{WINDOW2 translate <0.56,0.5,-0.601> pigment{color Wheat}}
	object{DOOR2 translate <0,-0.24,-0.921>}
}



object{HOUSE2 texture{T_Stone28 scale 0.25} rotate 90*y translate<2.5,0.1,-25.9>}

//LIGHT SOURCES INSIDE THE HOUSE

light_source{<1.8,0.8,-26.45> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{<1.8,0.8,-25.45> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }

//LIGHT SOURCE OVER THE DOOR OF THE HOUSE
light_source{
	<1.4,0.5,-25.95> 
	color rgb<clock*0.85,clock*0.85,clock*0.2> 
	spotlight
        radius 18
        falloff 23
        tightness .02
        point_at <1.44, 0, -25.95>
	fade_distance 3
        fade_power 1
}
light_source{
        <1.4,0.5,-25.95>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
	area_light <1.4, 0.51,-25.94>, <1.4,0.49,-25.96>, 1, 1
        adaptive 1
        jitter
	fade_distance 1 
	fade_power 10 
}


/////////////////////////////////////HOUSE 2 COMPLETE///////////////////////////////////////


/////////////////////////////////////HOUSE 3 ///////////////////////////////////////

object{HOUSE2 texture{T_Stone8} rotate 90*y translate<2.5,0.1,-23.8>}

light_source{<1.8,0.8,-24.35> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{<1.8,0.8,-23.35> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{
        <1.4,0.5,-23.85>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        spotlight
        radius 18
        falloff 23
        tightness .02
        point_at <1.42, 0, -23.85>
        fade_distance 3
        fade_power 1
}

/////////////////////////////////////HOUSE 3 COMPLETE///////////////////////////////////////

/////////////////////////////////////HOUSE 4 ///////////////////////////////////////

#declare BLUEBULB = union {
                sphere{ <0,0,1>, 1}
                texture{
                        pigment{color rgb<clock*0, clock*0, clock*1>}
                        finish{
                                ambient .8
                                diffuse .6
                              }
                }
                rotate -90*x
                scale .05
}


object {HOUSE1 translate<2.5,0.6,-21.7>}
light_source{<1.6,0.6,-21.3> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 1.8}
light_source{
                <1.5,1.4,-20.852>
                color rgb<clock*0,clock*0,clock*1>
                spotlight
                radius 20
                falloff 25
                tightness .2
                point_at <1.5, 0, -20.852>
                looks_like{BLUEBULB}
}
light_source{
        <1.5,1.4,-20.852>
        color rgb<clock*0,clock*0,clock*1>
        area_light <1.5,1.39,-20.853>, <1.5,1.41,-20.851>, 1, 1
        adaptive 1
        jitter
        fade_distance 2
        fade_power 1
}


/////////////////////////////////////////////////////////////////////////////

object{HOUSE2 texture{T_Stone29} rotate 90*y translate<2.5,0.1,-19.6>}

light_source{<1.8,0.8,-20.15> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{<1.8,0.8,-19.15> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{
        <1.4,0.5,-19.65>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        spotlight
        radius 18
        falloff 23
        tightness .02
        point_at <1.42, 0, -19.65>
        fade_distance 3
        fade_power 1
}

light_source{
        <1.4,0.5,-21.75>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        area_light <1.4, 0.51,-19.64>, <1.4,0.49,-19.66>, 1, 1
        adaptive 1
        jitter
        fade_distance 1
        fade_power 10
}

//////////////////////////////////////////////////////////////////////////////////////


object{HOUSE2 texture{T_Stone8} rotate 90*y translate<2.5,0.1,-17.5>}

light_source{<1.8,0.8,-18.05> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{<1.8,0.8,-17.05> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{
        <1.4,0.5,-17.55>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        spotlight
        radius 18
        falloff 23
        tightness .02
        point_at <1.42, 0, -17.55>
        fade_distance 3
        fade_power 1
}

//////////////////////////////////////////////////////////////////////////////////////

object{HOUSE2 texture{T_Stone8} rotate 90*y translate<2.5,0.1,-15.4>}

light_source{<1.8,0.8,-15.95> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{<1.8,0.8,-14.95> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{
        <1.4,0.5,-15.45>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        spotlight
        radius 18
        falloff 23
        tightness .02
        point_at <1.42, 0, -15.45>
        fade_distance 3
        fade_power 1
}
light_source{
        <1.4,0.5,-15.45>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        area_light <1.4, 0.51,-15.44>, <1.4,0.49,-15.46>, 1, 1
        adaptive 1
        jitter
        fade_distance 1
        fade_power 10
}

///////////////////////////house 8///////////////////////////////////


object{HOUSE2 texture{T_Stone10} rotate 90*y translate<2.5,0.1,-13.3>}

light_source{<1.8,0.8,-13.85> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{<1.8,0.8,-12.85> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{
        <1.4,0.5,-13.35>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        spotlight
        radius 18
        falloff 23
        tightness .02
        point_at <1.42, 0, -13.35>
        fade_distance 3
        fade_power 1
}
light_source{
        <1.4,0.5,-13.35>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        area_light <1.4, 0.51,-13.34>, <1.4,0.49,-13.36>, 1, 1
        adaptive 1
        jitter
        fade_distance 1
        fade_power 10
}


object{HOUSE2 texture{T_Stone28} rotate 90*y translate<2.5,0.1,-11.2>}

light_source{<1.8,0.8,-11.75> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{<1.8,0.8,-10.75> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{
        <1.4,0.5,-11.25>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        spotlight
        radius 18
        falloff 23
        tightness .02
        point_at <1.42, 0, -11.25>
        fade_distance 3
        fade_power 1
}
light_source{
        <1.4,0.5,-11.25>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        area_light <1.4, 0.51,-11.24>, <1.4,0.49,-11.26>, 1, 1
        adaptive 1
        jitter
        fade_distance 1
        fade_power 10
}

//////////////////////////////////////////////////////////////////////////////////////

object{HOUSE2 texture{T_Stone8} rotate 90*y translate<2.5,0.1,-9.1>}

light_source{<1.8,0.8,-9.65> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{<1.8,0.8,-8.65> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{
        <1.4,0.5,-9.15>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        spotlight
        radius 18
        falloff 23
        tightness .02
        point_at <1.42, 0, -9.15>
        fade_distance 3
        fade_power 1
}
light_source{
        <1.4,0.5,-9.15>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        area_light <1.4, 0.51,-9.14>, <1.4,0.49,-9.16>, 1, 1
        adaptive 1
        jitter
        fade_distance 1
        fade_power 10
}

//////////////////////////////////////////////////////////////////////////////////////


object{HOUSE2 texture{T_Stone29} rotate 90*y translate<2.5,0.1,-7>}

light_source{<1.8,0.8,-7.55> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{<1.8,0.8,-6.55> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{
        <1.4,0.5,-7.05>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        spotlight
        radius 18
        falloff 23
        tightness .02
        point_at <1.42, 0, -7.05>
        fade_distance 3
        fade_power 1
}
light_source{
        <1.4,0.5,-7.05>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        area_light <1.4, 0.51,-7.04>, <1.4,0.49,-7.06>, 1, 1
        adaptive 1
        jitter
        fade_distance 1
        fade_power 10
}

//////////////////////////////////////////////////////////////////////////////////////


object{HOUSE2 texture{T_Stone8} rotate 90*y translate<2.5,0.1,-4.9>}

light_source{<1.8,0.8,-5.45> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{<1.8,0.8,-4.45> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{
        <1.4,0.5,-4.95>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        spotlight
        radius 18
        falloff 23
        tightness .02
        point_at <1.42, 0, -4.95>
        fade_distance 3
        fade_power 1
}
light_source{
        <1.4,0.5,-4.95>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        area_light <1.4, 0.51,-4.94>, <1.4,0.49,-4.96>, 1, 1
        adaptive 1
        jitter
        fade_distance 1
        fade_power 10
}

//////////////////////////////////////////////////////////////////////////////////////



object{HOUSE2 texture{T_Stone18} rotate 90*y translate<2.5,0.1,-2.8>}

light_source{<1.8,0.8,-3.35> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{<1.8,0.8,-2.35> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{
        <1.4,0.5,-2.85>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        spotlight
        radius 18
        falloff 23
        tightness .02
        point_at <1.42, 0, -2.85>
        fade_distance 3
        fade_power 1
}
light_source{
        <1.4,0.5,-2.85>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        area_light <1.4, 0.51,-2.84>, <1.4,0.49,-2.86>, 1, 1
        adaptive 1
        jitter
        fade_distance 1
        fade_power 10
}

//////////////////////////////////////////////////////////////////////////////////////



object{HOUSE2 texture{T_Stone20} rotate 90*y translate<2.5,0.1,-0.7>}

light_source{<1.8,0.8,-1.25> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{<1.8,0.8,-0.25> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{
        <1.4,0.5,-0.75>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        spotlight
        radius 18
        falloff 23
        tightness .02
        point_at <1.42, 0, -0.75>
        fade_distance 3
        fade_power 1
}
light_source{
        <1.4,0.5,-0.75>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        area_light <1.4, 0.51,-0.74>, <1.4,0.49,-0.76>, 1, 1
        adaptive 1
        jitter
        fade_distance 1
        fade_power 10
}

//////////////////////////////////////////////////////////////////////////////////////

object{HOUSE2 texture{T_Stone8} rotate 90*y translate<2.5,0.1,1.4>}

light_source{<1.8,0.8,0.85> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{<1.8,0.8,1.85> color rgb<clock*0.85,clock*0.85,clock*0.2> fade_distance 2 fade_power 2 }
light_source{
        <1.4,0.5,1.35>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        spotlight
        radius 18
        falloff 23
        tightness .02
        point_at <1.42, 0, 1.35>
        fade_distance 3
        fade_power 1
}
light_source{
        <1.4,0.5,1.35>
        color rgb<clock*0.85,clock*0.85,clock*0.2>
        area_light <1.4, 0.51,1.34>, <1.4,0.49,1.36>, 1, 1
        adaptive 1
        jitter
        fade_distance 1
        fade_power 10
}

//////////////////////////////////////////////////////////////////////////////////////



//THE ROOF OF THE HOUSE


#declare ROOF = prism {
                        linear_sweep
                        linear_spline
                        0,
                        0.94,
                        3,
			<-1.3,0>, <1.3,0>, <0,0.5>
			scale <1,2,1>
                        rotate -90*x
			texture{T_Wood9}
}

#declare p = 2.35;
#declare i=-24.96;
   #while (i<p)
	object {ROOF translate<2.5,1.6,i>}
   #declare i=i+2.1;
#end




//FENCE OUTSIDE THE HOUSES

#declare p = 0;
#declare i=-31;
   #while (i<p)
        object {FENCE scale <0.2,0.16,1> translate <1.1,-0.35,i>}
   #declare i=i+0.6;
#end



//THE RED FIRE PUMP

#declare FIRE_PUMP =
	union{
		cylinder{<0,-0.6,0>, <0,0,0> 0.35 }
		torus{ 0.45,0.1 translate <0,0.1,0> }
		difference{
			sphere{<0,0.2,0> 0.35}
			box{<-0.35,-0.55,-0.35>, <0.35,0.2,0.35> }
			  }
	
		cylinder{<0.3,0.1,0>, <0.75,0.1,0> 0.08}

		pigment{Red}
		finish{
	                      ambient .1
	                      diffuse .4
	                      reflection .15
	                      specular 0.5
	                      roughness 0.0005
	                      metallic
		     }
scale 0.3
}


object{ FIRE_PUMP translate <-1.25,-0.2,-22.3>}


//Bright BALLS ARND THE BENCH

#declare Finish=finish{diffuse 0.6 ambient 0}
#declare White=texture{pigment{rgbf<1,1,1,0.6>} finish{Finish}}


#declare BRIGHT_SPHERE = sphere {
	<0,0,0>,0.1
	texture{ 
		White
		finish {
                        reflection {0.5 metallic}
                        diffuse 0.4

                        brilliance 1
                        specular 0.7
                        metallic
                       }
	       }
  }

object{BRIGHT_SPHERE  translate<-1.5,-0.3,-26.5>}
object{BRIGHT_SPHERE  translate<-1.62,-0.3,-25.62>}
object{BRIGHT_SPHERE  translate<-2,-0.3,-26.5>}




//Bench
#declare BENCH = union{
		box{<-0.7,0,0>, <0.7,0.35,0.1> texture{ T_Wood12 finish{diffuse .4}}}
		box{<-0.7,-0.13,-0.4>, <0.7,-0.03,0.1> texture{ T_Wood12 finish{diffuse .4}}}
		union{
	                cylinder{<-0.4,0.35,0.13>, <-0.4,-0.13,0.13> 0.03 }
	                cylinder{<0.4,0.35,0.13>, <0.4,-0.13,0.13> 0.03 }

	                cylinder{<-0.5,-0.13,-0.3>, <-0.5,-0.5,-0.3> 0.035 }
        	        cylinder{<-0.5,-0.13,0>, <-0.5,-0.5,0> 0.035 }   //Back leg ..left
                	cylinder{<0.5,-0.13,-0.3>, <0.5,-0.5,-0.3> 0.035 }
               		cylinder{<0.5,-0.13,0>, <0.5,-0.5,0> 0.035 } //Back leg ..right
			pigment{color rgb <0,0,0>}
		        finish{
		                specular 0.5
		                roughness 0.0005
		                reflection .15
		                brilliance 1
              		      }
		    }
rotate -90*y

}

#declare p = -22.8;
#declare i=-25.9;
   #while (i<p)
	object{BENCH scale 0.75 translate <-2,0.03,i>}
   #declare i=i+3;
#end

#declare p = 3;
#declare i=-17.9;
   #while (i<p)
        object{BENCH scale 0.75 translate <-2,0.03,i>}
   #declare i=i+5;
#end






/***************************************END OF PROGRAM ***********************************/









//background { texture {Starfield}}



/*
light_source { <100, 5, -15>
        color White
}


camera {
//   location <1.2, 0, -26>
//   location <1.4, 1.6, -24>
//   location <0, 0, 2>
//   location <2, 0.5, 0>
	location <0, 0, -30>
//     location <0, 0.8, -27.15>
//   look_at <-2, 0, -26>
//     look_at <2.5,1.6,-21.7>
   look_at 0
}

/*
plane {
      y, -0.5
//	pigment{color Black}
	pigment{checker color Red color Blue}
}*/

//light_source { <0, 2, -2> color White}
//light_source { <10, 2, -20> color White}
//light_source { <1,0,0> color White}
//light_source { <0,0,2> color White}
light_source { <0,0,-30> color White}
//light_source { <2.5, 333,-23.8> color White}
//light_source { <0, 100, 2200> color White}


//Left-Footpath
box {
	<-400,-0.5,-35>, <-1,-0.4,1150>
	texture{BRICK_TEXTURE}
//	pigment {brick Gray35, Gray15 rotate -90*x scale .1 }
//	normal { bumps 5 scale .5 }
}



//Right-Footpath
box {
        <1,-0.5,-35>, <400,-0.4,1150>
        texture{BRICK_TEXTURE}
//      pigment {brick Gray35, Gray15 rotate -90*x scale .1 }
//      normal { bumps 5 scale .5 }
}




light_source { <-0.608, 0.97, -28.2>
        color White
	spotlight 
	radius 30 
	falloff 35 
	tightness .02 
	point_at <-0.3, -0.5, -28.1>
        looks_like { Lightbulb }
}
*/


//light_source { <-5, 1.9, -18.4> color YellowGreen shadowless}




/*
#declare FENCE = polygon {
		        22,
			<0,1,0>, <0.1,0.6,0>
			<0.1,0.35,0>, <0.3,0.35,0>
			<0.3,0.25,0>, <0.1,0.25,0>
			<0.1,0,0>, <0.3,0,0>
			<0.3,-0.1,0>, <0.1,-0.1,0>
			<0.1,-0.45,0>, <-0.1,-0.45,0>
			<-0.1,-0.1,0>, <-0.3,-0.1,0>
			<-0.3,0,0>, <-0.1,0,0>
			<-0.1,0.25,0>, <-0.3,0.25,0>
			<-0.3,0.35,0>, <-0.1,0.35,0>
			<-0.1,0.6,0>, <0,1,0>
			rotate -90*y
		        pigment { color rgb <1, 1, 1> }
			finish{specular 1 roughness 0.0005}
}
*/

/*

object {FENCE translate <-7,-0.1,-31>}
object {FENCE translate <-7,-0.1,-30.4>}
object {FENCE translate <-7,-0.1,-29.8>}
object {FENCE translate <-7,-0.1,-29.2>}
object {FENCE translate <-7,-0.1,-28.6>}
object {FENCE translate <-7,-0.1,-28>}
object {FENCE translate <-7,-0.1,-27.4>}
object {FENCE translate <-7,-0.1,-26.8>}
object {FENCE translate <-7,-0.1,-26.2>}
object {FENCE translate <-7,-0.1,-25.6>}
object {FENCE translate <-7,-0.1,-25>}
object {FENCE translate <-7,-0.1,-24.4>}
object {FENCE translate <-7,-0.1,-23.8>}
object {FENCE translate <-7,-0.1,-23.2>}
object {FENCE translate <-7,-0.1,-22.6>}
object {FENCE translate <-7,-0.1,-22>}
object {FENCE translate <-7,-0.1,-21.4>}
object {FENCE translate <-7,-.1,-20.8>}
object {FENCE translate <-7,-.1,-20.2>}
object {FENCE translate <-7,-.1,-19.6>}
object {FENCE translate <-7,-.1,-19>}
object {FENCE translate <-7,-.1,-18.4>}
object {FENCE translate <-7,-.1,-17.8>}
object {FENCE translate <-7,-.1,-17.2>}
object {FENCE translate <-7,-.1,-16.6>}
object {FENCE translate <-7,-.1,-16>}
object {FENCE translate <-7,-0.1,-15.4>}
object {FENCE translate <-7,-0.1,-14.8>}
object {FENCE translate <-7,-0.1,-14.2>}
object {FENCE translate <-7,-0.1,-13.6>}
object {FENCE translate <-7,-0.1,-13>}
object {FENCE translate <-7,-0.1,-12.4>}
object {FENCE translate <-7,-0.1,-11.8>}
object {FENCE translate <-7,-0.1,-11.2>}
object {FENCE translate <-7,-0.1,-10.6>}
object {FENCE translate <-7,-0.1,-10>}
object {FENCE translate <-7,-0.1,-9.4>}
object {FENCE translate <-7,-0.1,-8.8>}
object {FENCE translate <-7,-0.1,-8.2>}
object {FENCE translate <-7,-0.1,-7.6>}
object {FENCE translate <-7,-0.1,-7>}
object {FENCE translate <-7,-0.1,-6.4>}
object {FENCE translate <-7,-.1,-5.8>}
object {FENCE translate <-7,-.1,-5.2>}
object {FENCE translate <-7,-.1,-4.6>}
object {FENCE translate <-7,-.1,-4>}
object {FENCE translate <-7,-.1,-3.4>}
object {FENCE translate <-7,-.1,-2.8>}
object {FENCE translate <-7,-.1,-2.2>}
object {FENCE translate <-7,-.1,-1.6>}
object {FENCE translate <-7,-.1,-1>}

object {FENCE translate <-7,-0.1,-0.4>}
object {FENCE translate <-7,-0.1,0.2>}
object {FENCE translate <-7,-0.1,0.8>}
object {FENCE translate <-7,-0.1,1.4>}
object {FENCE translate <-7,-0.1,2>}
object {FENCE translate <-7,-0.1,2.6>}
object {FENCE translate <-7,-0.1,3.2>}
object {FENCE translate <-7,-0.1,3.8>}
object {FENCE translate <-7,-0.1,4.4>}
object {FENCE translate <-7,-0.1,5>}
object {FENCE translate <-7,-0.1,5.6>}
object {FENCE translate <-7,-0.1,6.2>}
object {FENCE translate <-7,-.1,6.8>}
object {FENCE translate <-7,-.1,7.4>}
object {FENCE translate <-7,-.1,8>}
object {FENCE translate <-7,-.1,8.6>}
object {FENCE translate <-7,-.1,9.2>}
object {FENCE translate <-7,-.1,9.8>}
object {FENCE translate <-7,-.1,10.4>}
object {FENCE translate <-7,-.1,11>}
*/

/*
object {ROOF translate<2.5,1.6,-24.96>}
object {ROOF translate<2.5,1.6,-22.86>}
object {ROOF translate<2.5,1.6,-20.76>}
object {ROOF translate<2.5,1.6,-18.66>}
*/



/*
object{BENCH scale 0.75 translate <-2,0.03,-25.9>}
object{BENCH scale 0.75 translate <-2,0.03,-22.9>}
object{BENCH scale 0.75 translate <-2,0.03,-18.9>}
object{BENCH scale 0.75 translate <-2,0.03,-14.9>}
*/

























/*

sor {
        8,
        <0,0>, <0.0,0>, <0.2,0.8>, <0.4,0.8001>, <0.4, 1>, <0.2, 1.000001>, <0.2, 1.2>, <0, 1.4>
        open
        pigment{Red}
}

*/







/*

polygon {
        22,
        <0.6,1,0>, <0.7,0.6,0>

        <0.7,0.35,0>, <0.9,0.35,0>

        <0.9,0.25,0>, <0.7,0.25,0>

        <0.7,0,0>, <0.9,0,0>

        <0.9,-0.1,0>, <0.7,-0.1,0>

        <0.7,-0.45,0>, <0.5,-0.45,0>

        <0.5,-0.1,0>, <0.3,-0.1,0>

        <0.3,0,0>, <0.5,0,0>

        <0.5,0.25,0>, <0.3,0.25,0>

        <0.3,0.35,0>, <0.5,0.35,0>

        <0.5,0.6,0>, <0.6,1,0>

        pigment { color rgb <1, 1, 1> }
}


polygon {
        5,
        <0.1,-0.5,-35>, <0.1,-0.5,1150>,
        <-0.1,-0.5,1150>, <-0.1,-0.5,-35>,
        <0.1,-0.5,-35>
        pigment { color rgb 1 }
}*/


/*
#declare ROAD_STRIP = polygon {
                                5,
                                <0.1,-0.5,-0.75>, <0.1,-0.5,0.75>,
                                <-0.1,-0.5,0.75>,<-0.1,-0.5,-0.75>,
                                <0.1,-0.5,-0.75>
                                pigment { color rgb 1 }

}*/




/*

#declare B11=<-1,-0.5,-35>; #declare B12=<-0.25,-0.5,-35>; //
#declare B13=<0.25,-0.5,-35>; #declare B14=<1,-0.5,-35>; // row 1

#declare B21=<-1.33,-0.5,-27>; #declare B22=<-0.58,-0.5,-27>; //
#declare B23=<-0.08,-0.5,-27>; #declare B24=<0.66,-0.5,-27>; // row 2

#declare B31=<-1.66,-0.5,-19>; #declare B32=<-0.91,-0.5,-19>; //
#declare B33=<-0.41,-0.5,-19>; #declare B34=<0.33,-0.5,-19>; // row 3

#declare B41=<-2,-0.5,-10>; #declare B42=<-1.25,-0.5,-10>; //
#declare B43=<-0.75,-0.5,-10>; #declare B44=<0,-0.5,-10>; // row 4


#declare B11=<-1,-0.5,-35>; #declare B12=<-0.66,-0.5,-35>; //
#declare B13=<0.33,-0.5,-35>; #declare B14=<1,-0.5,-35>; // row 1

#declare B21=<-3,-0.5,-20>; #declare B22=<-2.66,-0.5,-20>; //
#declare B23=<-1.33,-0.5,-20>; #declare B24=<-1,-0.5,-20>; // row 2

#declare B31=<-8,-0.5,-5>; #declare B32=<-7.66,-0.5,-5>; //
#declare B33=<-6.33,-0.5,-5>; #declare B34=<-6,-0.5,-5>; // row 3

#declare B41=<-10,-0.5,10>; #declare B42=<-9.66,-0.5,10>; //
#declare B43=<-8.33,-0.5,10>; #declare B44=<-8,-0.5,10>; // row 4

bicubic_patch {
        type 1 flatness 0.001
        u_steps 4
        v_steps 4
        uv_vectors
        <0,0> <1,0> <1,1> <0,1>
 	B41, B42, B43, B44
        B31, B32, B33, B34
        B21, B22, B23, B24
        B11, B12, B13, B14
/*
        B11, B12, B13, B14
        B21, B22, B23, B24
        B31, B32, B33, B34
        B41, B42, B43, B44*/
        uv_mapping texture {
                                pigment { checker color rgbf <1,1,1,0.5> color rgbf <0,0,1,0.7>
                                scale 1/3
                                        }
                                finish {
                                         phong 0.6
                                         phong_size 20
                                       }
                          }
        no_shadow
}*/
