/*
 * Decompiled with CFR 0.152.
 */
package comprehensionapp;

import comprehensionapp.ComprehensionAboutBox;
import comprehensionapp.ComprehensionApp;
import comprehensionapp.Constants;
import comprehensionapp.Log;
import comprehensionapp.Logger;
import comprehensionapp.TextGenerator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;

public class ComprehensionView
extends FrameView {
    public static int IDNo = 0;
    public static int screenNo = 0;
    String id;
    private JTextField AnswerField;
    private JLabel AnswerLabel;
    private JTextArea QuestionTextArea;
    private JScrollPane jScrollPane1;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JButton submitButton;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public ComprehensionView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComprehensionView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComprehensionView.this.busyIconIndex = (ComprehensionView.this.busyIconIndex + 1) % ComprehensionView.this.busyIcons.length;
                ComprehensionView.this.statusAnimationLabel.setIcon(ComprehensionView.this.busyIcons[ComprehensionView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!ComprehensionView.this.busyIconTimer.isRunning()) {
                        ComprehensionView.this.statusAnimationLabel.setIcon(ComprehensionView.this.busyIcons[0]);
                        ComprehensionView.this.busyIconIndex = 0;
                        ComprehensionView.this.busyIconTimer.start();
                    }
                    ComprehensionView.this.progressBar.setVisible(true);
                    ComprehensionView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    ComprehensionView.this.busyIconTimer.stop();
                    ComprehensionView.this.statusAnimationLabel.setIcon(ComprehensionView.this.idleIcon);
                    ComprehensionView.this.progressBar.setVisible(false);
                    ComprehensionView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    ComprehensionView.this.statusMessageLabel.setText(text == null ? "" : text);
                    ComprehensionView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    ComprehensionView.this.progressBar.setVisible(true);
                    ComprehensionView.this.progressBar.setIndeterminate(false);
                    ComprehensionView.this.progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = ComprehensionApp.getApplication().getMainFrame();
            this.aboutBox = new ComprehensionAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        ComprehensionApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.submitButton = new JButton();
        this.AnswerField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.QuestionTextArea = new JTextArea();
        this.AnswerLabel = new JLabel();
        this.menuBar = new JMenuBar();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setName("mainPanel");
        ResourceMap resourceMap = Application.getInstance(ComprehensionApp.class).getContext().getResourceMap(ComprehensionView.class);
        this.submitButton.setText(resourceMap.getString("submitButton.text", new Object[0]));
        this.submitButton.setName("submitButton");
        this.submitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ComprehensionView.this.submitButtonActionPerformed(evt);
            }
        });
        this.AnswerField.setText(resourceMap.getString("AnswerField.text", new Object[0]));
        this.AnswerField.setName("AnswerField");
        this.jScrollPane1.setName("jScrollPane1");
        this.QuestionTextArea.setColumns(20);
        this.QuestionTextArea.setEditable(false);
        this.QuestionTextArea.setLineWrap(true);
        this.QuestionTextArea.setRows(5);
        this.QuestionTextArea.setWrapStyleWord(true);
        this.QuestionTextArea.setName("QuestionTextArea");
        this.QuestionTextArea.setText(TextGenerator.displayText(IDNo, 0, 0));
        this.jScrollPane1.setViewportView(this.QuestionTextArea);
        this.AnswerLabel.setText(resourceMap.getString("AnswerLabel.text", new Object[0]));
        this.AnswerLabel.setName("AnswerLabel");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 376, Short.MAX_VALUE).addComponent(this.AnswerField, GroupLayout.Alignment.LEADING, -1, 376, Short.MAX_VALUE).addComponent(this.submitButton, GroupLayout.Alignment.LEADING, -2, 153, -2).addComponent(this.AnswerLabel, GroupLayout.Alignment.LEADING)).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 148, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.AnswerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.AnswerField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.submitButton)));
        this.menuBar.setName("menuBar");
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 400, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 216, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        if (Constants.verbose) {
            System.out.println("You clicked the submit button on screen " + screenNo + " at " + System.currentTimeMillis() + " answering " + this.AnswerField.getText());
        }
        Logger.logs.add(new Log(this.AnswerField.getText(), System.currentTimeMillis()));
        if (screenNo == 48) {
            this.QuestionTextArea.setText("Congratulations! You are done.");
            Logger.writeToLogFile(Constants.homeDir + this.id + ".txt");
            if (Constants.verbose) {
                System.out.println("Successfully written to " + Constants.homeDir + this.id + ".txt");
            }
            System.exit(0);
        }
        if (screenNo == 0) {
            this.id = this.AnswerField.getText();
            int l = this.id.split("\\.").length;
            if (l == 2) {
                IDNo = Integer.parseInt(this.id.split("\\.")[1]) % 2;
            }
            if (Constants.verbose) {
                System.out.println("Your id No is " + IDNo);
                System.out.println("Your id is " + this.id);
            }
        }
        this.AnswerField.setText("");
        this.AnswerLabel.setText("Answer:");
        if (++screenNo % 6 == 1) {
            this.AnswerField.setEnabled(false);
            this.AnswerLabel.setEnabled(false);
            this.AnswerLabel.setVisible(false);
            this.QuestionTextArea.setLineWrap(true);
            this.QuestionTextArea.setText(TextGenerator.displayText(IDNo, screenNo, Constants.questionTextAreaID));
            this.AnswerLabel.setText(TextGenerator.displayText(IDNo, screenNo, Constants.answerLabelID));
            this.submitButton.setText("Start");
        } else {
            this.AnswerLabel.setVisible(true);
            this.AnswerLabel.setEnabled(true);
            this.AnswerField.setEnabled(true);
            this.QuestionTextArea.setLineWrap(true);
            this.QuestionTextArea.setText(TextGenerator.displayText(IDNo, screenNo, Constants.questionTextAreaID));
            this.submitButton.setText("Submit");
        }
    }
}

