/*
 * Decompiled with CFR 0.152.
 */
package comprehensionapp;

import comprehensionapp.Constants;
import java.io.BufferedReader;
import java.io.FileReader;

public class TextGenerator {
    public static String displayText(int idNo, int screenNo, int componentNo) {
        String text = "";
        if (componentNo == Constants.answerLabelID) {
            return "Answer:";
        }
        if (componentNo == Constants.questionTextAreaID) {
            switch (screenNo) {
                case 0: {
                    text = TextGenerator.getTextFromFile(Constants.rulesFile);
                    return text;
                }
            }
            String fileName = TextGenerator.getFileName(screenNo, idNo);
            text = TextGenerator.getTextFromFile(fileName);
            return text;
        }
        return text;
    }

    private static String getTextFromFile(String rulesFile) {
        String out = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader(rulesFile));
            String line = "";
            do {
                line = in.readLine();
                out = out + line + "\n";
            } while (line != null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out;
    }

    private static String getFileName(int screenNo, int idNo) {
        String fileName = "";
        String baseName = "";
        if (screenNo > 0 && screenNo <= 6) {
            baseName = "Art/Art." + idNo + ".";
        } else if (screenNo > 6 && screenNo <= 12) {
            baseName = "Culture/Culture." + idNo + ".";
        } else if (screenNo > 12 && screenNo <= 18) {
            baseName = "History/History." + idNo + ".";
        } else if (screenNo > 18 && screenNo <= 24) {
            baseName = "Film/Film." + idNo + ".";
        } else if (screenNo > 24 && screenNo <= 30) {
            baseName = "Music/Music." + idNo + ".";
        } else if (screenNo > 30 && screenNo <= 36) {
            baseName = "Sports/Sports." + idNo + ".";
        } else if (screenNo > 36 && screenNo <= 42) {
            baseName = "Science/Science." + idNo + ".";
        } else if (screenNo > 42 && screenNo <= 48) {
            baseName = "World/World." + idNo + ".";
        } else {
            return Constants.rulesFile;
        }
        fileName = baseName + (screenNo - 1) % 6 + ".txt";
        return Constants.homeDir + fileName;
    }
}

