/*
 * ComprehensionApp.java
 */

package comprehensionapp;

import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

/**
 * The main class of the application.
 */
public class ComprehensionApp extends SingleFrameApplication {

    /**
     * At startup create and show the main frame of the application.
     */
    @Override protected void startup() {
        show(new ComprehensionView(this));
    }

    /**
     * This method is to initialize the specified window by injecting resources.
     * Windows shown in our application come fully initialized from the GUI
     * builder, so this additional configuration is not needed.
     */
    @Override protected void configureWindow(java.awt.Window root) {
    }

    /**
     * A convenient static getter for the application instance.
     * @return the instance of ComprehensionApp
     */
    public static ComprehensionApp getApplication() {
        return Application.getInstance(ComprehensionApp.class);
    }

    /**
     * Main method launching the application.
     */
    public static void main(String[] args) {
        Constants.homeDir = args[0];
        Constants.rulesFile = Constants.homeDir + "Rules.txt";
        //Constants.homeDir = "/home/sanpra/Desktop/data/";
        System.out.println(args.length);
        for(int i = 0; i < args.length; i++) {
            System.out.println(i + " " + args[i]);
        }
        launch(ComprehensionApp.class, args);
    }
}
