import numpy as np
import matplotlib.pyplot as plt


############################################################
########### INPUT/OUTPUT/VISUALIZATION FUNCTIONS ###########
################## (NEED NOT BE MODIFIED) ##################

# A function to load the dataset from a csvfile present at fpath.
# Returns matrix x and vector y containing the input datapoints
# and their corresponding classifications respectively.

def load_data(fpath):

    arr = np.genfromtxt(fpath, delimiter=',')
    arr = arr[1:,:]
    x, y = arr[:,:-1], arr[:,-1]

    return x, y

# A function to visualize the input dataset. It should
# only be called when the data has exactly 2 features.
# It has no return value.

def visualize_data(x,y,fpath):

    if x.shape[1] != 2: return

    colors = y.tolist()
    plt.scatter(x[:,0],x[:,1], c=colors)

    plt.ylabel('x2')
    plt.xlabel('x1')

    plotfile = fpath.rsplit('.',maxsplit=1)[0]+'_original.png'
    plt.savefig(plotfile)
    plt.close()

# A function to visualize the input dataset, along with the calculated
# separating hyperplane. It should only be called when the input data
# has exactly 2 features. It has no return value

def visualize_result(x,y,w,fpath):

    if x.shape[1] != 2: return

    if w[0] == 0 and w[1]==0:
        print("The separating hyperplane calculated for", fpath, "could not be plotted.")
        return

    elif w[0] == 0: plt.axhline(y = -1*w[2]/w[1], color='red')
    elif w[1] == 0: plt.axvline(x=-1*w[2]/w[0], color='red')
    else: plt.axline((-1*w[2]/w[0], 0), slope=-1*w[0]/w[1], color='red')

    colors = y.tolist()
    plt.scatter(x[:,0],x[:,1], c=colors)

    plt.xlabel('x1')
    plt.ylabel('x2')

    plotfile = fpath.rsplit('.',maxsplit=1)[0]+'_separated.png'
    plt.savefig(plotfile)
    plt.close()

# A function to print the equation of the hyperplane calculated by
# the perceptron algorithm to the terminal, and check how many input
# points it classifies correctly. No return value.

def print_result(x,y,w,fpath):

    # formatting the hyperplane equation as a string

    terms = list()
    for i in range(len(w)):
        if i==len(w)-1: terms.append(str(w[i]))
        else: terms.append(str(round(w[i],4)) + 'x' + str(i+1))

    eqn = ' + '.join(terms) + ' = 0'

    # counting the number of points correctly classified

    pos, neg, zer, n = 0, 0, 0, x.shape[0]
    x = np.c_[ x, np.ones(n) ]

    for i in range(n):
        prod = y[i] * np.dot(w,x[i,:])
        if prod < 0: neg += 1
        elif prod > 0: pos += 1
        else: zer += 1

    correct = np.max([pos, neg])

    # printing all the generated results to the terminal

    print("=============================================")
    print("For the input data in",fpath)
    print("the calculated separating hyperplane has the equation:")
    print(eqn)

    print("It correctly classifies",correct,"of the",n,"input datapoints.")
    print("=============================================")


############################################################
#### PERCEPTRON ALGORITHM AND FEATURE ADDITION FUNCTIONS ###
###################### TO BE MODIFIED ######################

# Given matrix x of datapoints and vector y of corresponding classes,
# this function computes the vector w containing the coefficients
# of the separating hyperplane. It should terminate gracefully when the
# dataset is not linearly separable. Returns the vector w.

def perceptron_algorithm(x,y):

    # number of datapoints
    n = x.shape[0]

    # adding a feature of 1s to x (to account for the bias factor)
    x = np.c_[ x, np.ones(n) ]

    #number of features
    f = x.shape[1]

    # the separating hyperplane, to be calculated
    w = np.zeros(f)

    # below: implement the iterative perceptron algorithm
    # while there exists some ith datapoint s.t. y_i * (w dot x_i) <= 0
    # set w = w + y_i*x_i

    # terminate and print failure if the iterations go on for too long
    # i.e. if the dataset is not linearly separable

    ########## YOUR CODE GOES BELOW ##########



    ########## YOUR CODE GOES ABOVE ##########

    return w

# Given a matrix x of datapoints, this function adds a new feature column
# to the matrix. This new feature should make the dataset linearly separable.
# Returns the updated matrix x.

def feature_addition(x):

    # number of datapoints
    n = x.shape[0]

    # x is currently a n x 2 matrix, (assuming you are working with dataset_4.csv)
    # i.e. it contains n datapoints with two features each (x1 and x2).
    # Let's add a third column to x that we will fill with a new feature:

    x = np.c_[ x, np.ones(n) ]

    # For each datapoint in x, define a new feature x3.
    # x3 should be defined such that it makes the dataset linearly separable
    # For example, you could use the values of x1 and/or x2 to define x3
    # Insert the calculated values of x3 into the new third column of x.

    ########## YOUR CODE GOES BELOW ##########



    ########## YOUR CODE GOES ABOVE ##########

    return x
