from lab1_functions import *


#### Part 1: A dataset that is linearly separable in its original form

# path of file containing the input points and their classes
dataset_file = './dataset_1.csv'
# you can change this to ./dataset_2.csv or ./dataset_3.csv as well
# or to any file containing linearly separable input data in appropriate format

# loading the data from the csv file
x_data, y_data = load_data(dataset_file)

# visualizing the data if it has 2 features
if x_data.shape[1] == 2: visualize_data(x_data, y_data, dataset_file)

# get the separating hyperplane
w_result = perceptron_algorithm(x_data, y_data)

# print the hyperplane equation and its correctness to the terminal
print_result(x_data, y_data, w_result, dataset_file)

# visualizing the result if it has 2 features
if x_data.shape[1] == 2: visualize_result(x_data, y_data, w_result, dataset_file)



#### Part 2: A dataset that requires the definition of an additional feature
#### to become linearly separable

# path of file containing the input points and their classes
# which are not linearly separable in their original form
dataset_file = './dataset_4.csv'

# loading the data from the csv file
x_data, y_data = load_data(dataset_file)

# visualizing the data if it has 2 features
if x_data.shape[1] == 2: visualize_data(x_data, y_data, dataset_file)

#add a feature to the dataset using its existing features
x_data = feature_addition(x_data)

# get the separating hyperplane
w_result = perceptron_algorithm(x_data, y_data)

# print the hyperplane equation and its correctness to the terminal
print_result(x_data, y_data, w_result, dataset_file)
