setwd('/Users/hzafar/Acads/Research/Fake_News_Detector')
library(readxl)
library(sjPlot)
library(ggplot2)
library(factoextra)
library(ggpubr)
library(ggsignif)

cdata = read_excel('Comp2.xlsx')
attach(cdata)

a <- data.frame(group = "TruthBot", value = cdata$TruthBot, query = cdata$Query)
b <- data.frame(group = "IFCN Bot", value = cdata$IFCN, query = cdata$Query)
df <- rbind(a, b)
labels <- c(FAQ = "FAQ", FAKE = "FAKE", GEN = "GEN")

my_comparisons = list(c("TruthBot", "IFCN Bot"))
p = ggplot(df, aes(x=group, y=value, fill=group)) + geom_boxplot(width=0.4) + ggsignif::geom_signif(comparisons = my_comparisons, test = "t.test")
#p = p + stat_compare_means(comparisons = my_comparisons, label.y = 1.05, method = "t.test", map_signif_level = TRUE) 
p = p + xlab("") + ylab("Response Accuracy") #+ ylim(0,1.08)
p = p + scale_fill_manual(values=c("dodgerblue3","darkorange2"))
p = p + scale_x_discrete(labels=c("a" = "", "b" = ""))
p = p + theme(axis.text.x = element_text(face="bold", family = "serif", 
                                         size=16, angle = 30, hjust = 1),
              axis.text.y = element_text(face="bold", family = "serif",
                                         size=12),
              axis.title = element_text(face="bold", family = "serif",
                                        size=16),
              plot.title = element_text(hjust = 0.5, face="bold", family = "serif",
                                        size=16),
              legend.position = "none")
p = p + facet_wrap(. ~ query, nrow = 1, labeller=labeller(query = labels)) +
  theme(strip.text.x = element_text(size=16, face="bold"),
        strip.background = element_rect(colour="#000066", fill="#CCCCFF"))
p
ggsave("Comparison_Metric_2.pdf", p, width=10, height = 4.5, units = "in")